/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo3.integration;

import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.dubbo3.DubboAdapter;
import org.noear.solon.extend.dubbo3.EnableDubbo;
import org.noear.solon.extend.dubbo3.integration.DubboReferenceAnno;
import org.noear.solon.extend.dubbo3.integration.DubboServiceAnno;
import org.noear.solon.extend.dubbo3.integration.ReferenceAnno;
import org.noear.solon.extend.dubbo3.integration.ServiceAnno;

public class XPluginImp
implements Plugin {
    DubboAdapter _server;

    public void start(AopContext context) {
        if (Solon.global().source().getAnnotation(EnableDubbo.class) == null) {
            return;
        }
        this._server = DubboAdapter.global();
        this.startForOldAnno(context);
        this.startForNewAnno(context);
    }

    private void startForOldAnno(AopContext context) {
        context.beanBuilderAdd(Service.class, (clz, bw, anno) -> {
            Class<?>[] ifs = bw.clz().getInterfaces();
            if (ifs.length > 0) {
                ServiceConfig cfg = new ServiceConfig((Service)new ServiceAnno((Service)anno));
                if (cfg.getInterface() == null) {
                    cfg.setInterface(ifs[0]);
                }
                cfg.setRef(bw.raw());
                this._server.regService(cfg);
            }
        });
        context.beanInjectorAdd(Reference.class, (fwT, anno) -> {
            if (fwT.getType().isInterface()) {
                Object raw = this._server.getService(fwT.getType(), new ReferenceAnno((Reference)anno));
                fwT.setValue(raw);
            }
        });
    }

    private void startForNewAnno(AopContext context) {
        context.beanBuilderAdd(DubboService.class, (clz, bw, anno) -> {
            Class<?>[] ifs = bw.clz().getInterfaces();
            if (ifs.length > 0) {
                ServiceConfig cfg = new ServiceConfig((Service)new DubboServiceAnno((DubboService)anno));
                if (cfg.getInterface() == null) {
                    cfg.setInterface(ifs[0]);
                }
                cfg.setRef(bw.raw());
                this._server.regService(cfg);
            }
        });
        context.beanInjectorAdd(DubboReference.class, (fwT, anno) -> {
            if (fwT.getType().isInterface()) {
                Object raw = this._server.getService(fwT.getType(), new DubboReferenceAnno((DubboReference)anno));
                fwT.setValue(raw);
            }
        });
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stopBlock();
        this._server = null;
    }
}

