/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo3.integration;

import java.util.List;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.dubbo3.EnableDubbo;
import org.noear.solon.extend.dubbo3.integration.DubboReferenceAnno;
import org.noear.solon.extend.dubbo3.integration.DubboServiceAnno;
import org.noear.solon.extend.dubbo3.integration.Protocols;
import org.noear.solon.extend.dubbo3.integration.ReferenceAnno;
import org.noear.solon.extend.dubbo3.integration.Registries;
import org.noear.solon.extend.dubbo3.integration.ServiceAnno;

public class XPluginImp
implements Plugin {
    private DubboBootstrap bootstrap;
    private Thread blockThread = null;

    public void start(AppContext context) {
        if (Solon.app().source().getAnnotation(EnableDubbo.class) == null) {
            return;
        }
        this.bootstrap = DubboBootstrap.getInstance();
        this.initialize();
        this.register(context);
        this.bootstrap.start();
        this.startBlock();
    }

    private void initialize() {
        Protocols protocols;
        ApplicationConfig application = (ApplicationConfig)Solon.cfg().getBean("dubbo.application", ApplicationConfig.class);
        if (application == null) {
            application = new ApplicationConfig();
        }
        if (application.getName() == null) {
            application.setName(Solon.cfg().appGroup() + "-" + Solon.cfg().appName());
        }
        this.bootstrap.application(application);
        Registries registries = (Registries)Solon.cfg().getBean("dubbo.registries", Registries.class);
        if (registries != null && registries.size() > 0) {
            this.bootstrap.registries((List)registries);
        } else {
            RegistryConfig registry = (RegistryConfig)Solon.cfg().getBean("dubbo.registry", RegistryConfig.class);
            if (registry == null) {
                registry = new RegistryConfig();
            }
            if (registry.getAddress() == null) {
                registry.setAddress("A/N");
            }
            this.bootstrap.registry(registry);
        }
        ProviderConfig provider = (ProviderConfig)Solon.cfg().getBean("dubbo.provider", ProviderConfig.class);
        if (provider != null) {
            this.bootstrap.provider(provider);
        }
        if ((protocols = (Protocols)Solon.cfg().getBean("dubbo.protocols", Protocols.class)) != null && protocols.size() > 0) {
            this.bootstrap.protocols((List)protocols);
        } else {
            ProtocolConfig protocol = (ProtocolConfig)Solon.cfg().getBean("dubbo.protocol", ProtocolConfig.class);
            if (protocol == null) {
                protocol = new ProtocolConfig();
            }
            if (protocol.getName() == null) {
                protocol.setName("dubbo");
                int port = Solon.cfg().serverPort() + 20000;
                protocol.setPort(Integer.valueOf(port));
            }
            this.bootstrap.protocol(protocol);
        }
        ConsumerConfig consumer = (ConsumerConfig)Solon.cfg().getBean("dubbo.consumer", ConsumerConfig.class);
        if (consumer != null) {
            this.bootstrap.consumer(consumer);
        }
    }

    private void register(AppContext context) {
        context.beanBuilderAdd(DubboService.class, (clz, bw, anno) -> {
            Class<?>[] interfaces = clz.getInterfaces();
            if (interfaces.length > 0) {
                ServiceConfig config = new ServiceConfig((Service)new DubboServiceAnno((DubboService)anno));
                if (config.getInterface() == null) {
                    config.setInterface(interfaces[0]);
                }
                config.setRef(bw.get());
                config.export();
                this.bootstrap.service(config);
            }
        });
        context.beanInjectorAdd(DubboReference.class, (holder, anno) -> {
            if (holder.getType().isInterface()) {
                ReferenceConfig config = new ReferenceConfig((Reference)new DubboReferenceAnno((DubboReference)anno));
                config.setInterface(holder.getType());
                this.bootstrap.reference(config);
                holder.setValue(config.get());
            }
        });
        context.beanBuilderAdd(Service.class, (clz, bw, anno) -> {
            Class<?>[] interfaces = clz.getInterfaces();
            if (interfaces.length > 0) {
                ServiceConfig config = new ServiceConfig((Service)new ServiceAnno((Service)anno));
                if (config.getInterface() == null) {
                    config.setInterface(interfaces[0]);
                }
                config.setRef(bw.get());
                config.export();
                this.bootstrap.service(config);
            }
        });
        context.beanInjectorAdd(Reference.class, (holder, anno) -> {
            if (holder.getType().isInterface()) {
                ReferenceConfig config = new ReferenceConfig((Reference)new ReferenceAnno((Reference)anno));
                config.setInterface(holder.getType());
                this.bootstrap.reference(config);
                holder.setValue(config.get());
            }
        });
    }

    public void prestop() throws Throwable {
        if (this.bootstrap != null) {
            this.bootstrap.stop();
            this.bootstrap = null;
        }
    }

    public void stop() {
        this.stopBlock();
    }

    public void startBlock() {
        if (this.blockThread == null) {
            this.blockThread = new Thread(() -> {
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.blockThread.start();
        }
    }

    public void stopBlock() {
        if (this.blockThread != null) {
            this.blockThread.interrupt();
            this.blockThread = null;
        }
    }
}

