/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.view;

import cn.afterturn.easypoi.view.AbstractView;
import cn.afterturn.easypoi.view.EasypoiBigExcelExportView;
import cn.afterturn.easypoi.view.EasypoiMapExcelView;
import cn.afterturn.easypoi.view.EasypoiSingleExcelView;
import cn.afterturn.easypoi.view.EasypoiTemplateExcelView;
import cn.afterturn.easypoi.view.MapGraphExcelView;
import cn.afterturn.easypoi.view.MiniAbstractExcelView;
import java.util.Map;
import org.noear.solon.core.handle.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoiBaseView
extends AbstractView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiBaseView.class);

    protected static boolean isIE(Context ctx) {
        return ctx.header("USER-AGENT").toLowerCase().indexOf("msie") > 0 || ctx.header("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0 || ctx.header("USER-AGENT").toLowerCase().indexOf("edge") > 0;
    }

    public static void render(Map<String, Object> model, Context ctx, String viewName) {
        MiniAbstractExcelView view = null;
        if ("easypoiBigExcelView.poi".equals(viewName)) {
            view = new EasypoiBigExcelExportView();
        } else if ("easypoiMapExcelView.poi".equals(viewName)) {
            view = new EasypoiMapExcelView();
        } else if ("easypoiExcelView.poi".equals(viewName)) {
            view = new EasypoiSingleExcelView();
        } else if ("easypoiTemplateExcelView.poi".equals(viewName)) {
            view = new EasypoiTemplateExcelView();
        } else if ("MapGraphExcelView.poi".equals(viewName)) {
            view = new MapGraphExcelView();
        }
        try {
            ((AbstractView)view).renderOutputModel(model, ctx);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }
}

