/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.view;

import cn.afterturn.easypoi.util.WebFilenameUtils;
import cn.afterturn.easypoi.view.PoiBaseView;
import cn.afterturn.easypoi.word.WordExportUtil;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.handle.Context;

@Component(value="easypoiTemplateWordView.poi")
public class EasypoiTemplateWordView
extends PoiBaseView {
    private static final String CONTENT_TYPE = "application/msword";

    public EasypoiTemplateWordView() {
        this.setContentType(CONTENT_TYPE);
    }

    @Override
    protected void renderOutputModel(Map<String, Object> model, Context ctx) throws Exception {
        String codedFileName = "\u4e34\u65f6\u6587\u4ef6.docx";
        if (model.containsKey("fileName")) {
            codedFileName = (String)model.get("fileName") + ".docx";
        }
        ctx.headerSet("content-disposition", WebFilenameUtils.disposition((String)codedFileName));
        XWPFDocument document = WordExportUtil.exportWord07((String)((String)model.get("url")), (Map)((Map)model.get("map")));
        OutputStream out = ctx.outputStream();
        document.write(out);
        out.flush();
    }
}

