/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.wps.controller;

import cn.afterturn.easypoi.wps.entity.WpsToken;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileHistoryRequest;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileHistoryResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileSaveResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsRenameRequest;
import cn.afterturn.easypoi.wps.entity.resreq.WpsResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsUserRequest;
import cn.afterturn.easypoi.wps.service.IEasyPoiWpsViewService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;
import org.noear.solon.annotation.Post;
import org.noear.solon.annotation.Put;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@Mapping(value="easypoi/wps/v1/3rd/file")
public class EasyPoiFileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EasyPoiFileController.class);
    @Inject(required=false)
    private IEasyPoiWpsViewService easyPoiWpsService;

    @Get
    @Mapping(value="getViewUrl")
    public WpsToken getViewUrl(String filePath) {
        LOGGER.info("getViewUrlWebPath\uff1afilePath={}", (Object)filePath);
        WpsToken token = this.easyPoiWpsService.getViewUrl(this.decode(filePath));
        return token;
    }

    @Get
    @Mapping(value="info")
    public WpsFileResponse getFileInfo(Context ctx, @Param(value="_w_userid") String userId, @Param(value="_w_filepath") String filePath) {
        LOGGER.info("\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636euserId:{},path:{}", (Object)userId, (Object)filePath);
        String fileId = ctx.header("x-weboffice-file-id");
        WpsFileResponse fileResponse = this.easyPoiWpsService.getFileInfo(userId, this.decode(filePath), fileId);
        return fileResponse;
    }

    @Post
    @Mapping(value="online")
    public WpsResponse fileOnline(Context ctx, @Body WpsUserRequest list) {
        LOGGER.info("\u901a\u77e5\u6b64\u6587\u4ef6\u76ee\u524d\u6709\u54ea\u4e9b\u4eba\u6b63\u5728\u534f\u4f5cparam:{}", (Object)list);
        String fileId = ctx.header("x-weboffice-file-id");
        this.easyPoiWpsService.fileOnline(fileId, list);
        return WpsResponse.success();
    }

    @Post
    @Mapping(value="save")
    public WpsFileSaveResponse fileSave(Context ctx, @Param(value="_w_userid") String userId, @Body UploadedFile file) {
        LOGGER.info("\u4e0a\u4f20\u6587\u4ef6\u65b0\u7248\u672c");
        String fileId = ctx.header("x-weboffice-file-id");
        return new WpsFileSaveResponse(this.easyPoiWpsService.fileSave(fileId, userId, file));
    }

    @Get
    @Mapping(value="version/{version}")
    public WpsFileSaveResponse fileVersion(Context ctx, Integer version, @Param(value="_w_filepath") String filePath) {
        LOGGER.info("\u83b7\u53d6\u7279\u5b9a\u7248\u672c\u7684\u6587\u4ef6\u4fe1\u606fversion:{}", (Object)version);
        String fileId = ctx.header("x-weboffice-file-id");
        return new WpsFileSaveResponse(this.easyPoiWpsService.getFileInfoOfVersion(fileId, this.decode(filePath), version));
    }

    @Put
    @Mapping(value="rename")
    public WpsResponse fileRename(Context ctx, @Body WpsRenameRequest req, @Param(value="_w_userid") String userId) {
        LOGGER.info("\u6587\u4ef6\u91cd\u547d\u540dparam:{},userId:{}", (Object)req, (Object)userId);
        String fileId = ctx.header("x-weboffice-file-id");
        this.easyPoiWpsService.rename(fileId, userId, req.getName());
        return WpsResponse.success();
    }

    @Post
    @Mapping(value="history")
    public WpsFileHistoryResponse fileHistory(@Body WpsFileHistoryRequest req) {
        LOGGER.info("\u83b7\u53d6\u6240\u6709\u5386\u53f2\u7248\u672c\u6587\u4ef6\u4fe1\u606fparam:{}", (Object)req);
        return this.easyPoiWpsService.getHistory(req);
    }

    @Post
    @Mapping(value="new")
    public WpsResponse fileNew(@Body UploadedFile file, @Param(value="_w_userid") String userId) {
        LOGGER.info("\u65b0\u5efa\u6587\u4ef6,\u53ea\u6253\u5370\u4e0d\u5b9e\u73b0,userid:{}", (Object)userId);
        return WpsResponse.success();
    }

    @Post
    @Mapping(value="onnotify")
    public WpsResponse onNotify(@Body Map obj) {
        LOGGER.info("\u56de\u8c03\u901a\u77e5,\u53ea\u6253\u5370\u4e0d\u5b9e\u73b0,param:{}", (Object)obj);
        return WpsResponse.success();
    }

    public String decode(String filePath) {
        try {
            filePath = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return filePath;
    }
}

