package com.jfinal.template;

/**
 * 定义指令工厂默认实现
 * @author noear 2024/5/26 created
 */
public class DirectiveFactoryDefault implements DirectiveFactory {
    private Class<? extends Directive> directiveClass;

    public DirectiveFactoryDefault(Class<? extends Directive> directiveClass) {
        this.directiveClass = directiveClass;
    }

    @Override
    public Directive createDirective() throws Exception {
        return directiveClass.getDeclaredConstructor().newInstance();
    }
}
