/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;

public class Logic
extends Expr {
    private Sym op;
    private Expr left;
    private Expr right;

    public Logic(Sym op, Expr left, Expr right, Location location) {
        if (left == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator on the left side can not be blank", location);
        }
        if (right == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator on the right side can not be blank", location);
        }
        this.op = op;
        this.left = left;
        this.right = right;
        this.location = location;
    }

    public Logic(Sym op, Expr right, Location location) {
        if (right == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator on the right side can not be blank", location);
        }
        this.op = op;
        this.left = null;
        this.right = right;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        switch (this.op) {
            case NOT: {
                return this.evalNot(scope);
            }
            case AND: {
                return this.evalAnd(scope);
            }
            case OR: {
                return this.evalOr(scope);
            }
        }
        throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
    }

    Object evalNot(Scope scope) {
        return !Logic.isTrue(this.right.eval(scope));
    }

    Object evalAnd(Scope scope) {
        return Logic.isTrue(this.left.eval(scope)) && Logic.isTrue(this.right.eval(scope));
    }

    Object evalOr(Scope scope) {
        return Logic.isTrue(this.left.eval(scope)) || Logic.isTrue(this.right.eval(scope));
    }

    public static boolean isTrue(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof CharSequence) {
            return ((CharSequence)v).length() > 0;
        }
        return true;
    }

    public static boolean isFalse(Object v) {
        return !Logic.isTrue(v);
    }
}

