/*
 * Decompiled with CFR 0.152.
 */
package org.noear.esearchx;

import java.io.IOException;
import java.rmi.ServerException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.noear.esearchx.Constants;
import org.noear.esearchx.exception.NoExistException;
import org.noear.esearchx.exception.RequestException;

class PriHttpUtils {
    private static final Supplier<Dispatcher> httpClientDefaultDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(Constants.HttpMaxRequests);
        temp.setMaxRequestsPerHost(Constants.HttpMaxRequestsPerHost);
        return temp;
    };
    private static final OkHttpClient httpClientDefault = new OkHttpClient.Builder().connectTimeout((long)Constants.HttpConnectTimeoutSeconds, TimeUnit.SECONDS).writeTimeout((long)Constants.HttpWriteTimeoutSeconds, TimeUnit.SECONDS).readTimeout((long)Constants.HttpReadTimeoutSeconds, TimeUnit.SECONDS).dispatcher(httpClientDefaultDispatcher.get()).build();
    private final OkHttpClient _client;
    private RequestBody _body;
    private Request.Builder _builder;

    public static PriHttpUtils http(String url) {
        return new PriHttpUtils(url);
    }

    public PriHttpUtils(String url) {
        this(url, httpClientDefault);
    }

    public PriHttpUtils(String url, OkHttpClient client) {
        this._builder = new Request.Builder().url(url);
        this._client = client;
    }

    public PriHttpUtils header(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this._builder.header(name, value);
        return this;
    }

    public PriHttpUtils bodyTxt(String txt, String contentType) {
        if (txt == null) {
            return this;
        }
        this._body = contentType == null ? FormBody.create(null, (String)txt) : FormBody.create((MediaType)MediaType.parse((String)contentType), (String)txt);
        return this;
    }

    public Response exec(String mothod) throws IOException {
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not supported");
            }
        }
        Call call = this._client.newCall(this._builder.build());
        return call.execute();
    }

    public String execAsBody(String mothod) throws IOException {
        Response tmp = this.exec(mothod);
        int code = tmp.code();
        String text = tmp.body().string();
        if (code >= 200 && code <= 300) {
            return text;
        }
        if (code == 404) {
            throw new NoExistException(text);
        }
        if (code >= 500) {
            throw new ServerException(text);
        }
        throw new RequestException(text);
    }

    public int execAsCode(String mothod) throws IOException {
        return this.exec(mothod).code();
    }

    public String get() throws IOException {
        return this.execAsBody("GET");
    }

    public String post() throws IOException {
        return this.execAsBody("POST");
    }

    public String put() throws IOException {
        return this.execAsBody("PUT");
    }

    public String patch() throws IOException {
        return this.execAsBody("PATCH");
    }

    public String delete() throws IOException {
        return this.execAsBody("DELETE");
    }

    public int head() throws IOException {
        return this.execAsCode("HEAD");
    }
}

