/*
 * Decompiled with CFR 0.152.
 */
package org.noear.esearchx.model;

import java.util.Arrays;
import java.util.function.Consumer;
import org.noear.esearchx.model.EsCondition;
import org.noear.esearchx.model.EsRanges;
import org.noear.esearchx.model.EsSort;
import org.noear.esearchx.model.EsTerms;
import org.noear.snack.ONode;

public class EsAggs {
    private final ONode oNode;
    private ONode lastLevl2Node;

    public EsAggs(ONode oNode) {
        this.oNode = oNode;
    }

    private ONode getLevl2Node(String name) {
        this.lastLevl2Node = this.oNode.getOrNew(name);
        return this.lastLevl2Node;
    }

    private void funSet(String asField, String field, String funName) {
        this.getLevl2Node(asField).getOrNew(funName).set("field", (Object)field);
    }

    public EsAggs sum(String field) {
        this.funSet(field + "_sum", field, "sum");
        return this;
    }

    public EsAggs avg(String field) {
        this.funSet(field + "_avg", field, "avg");
        return this;
    }

    public EsAggs max(String field) {
        this.funSet(field + "_max", field, "max");
        return this;
    }

    public EsAggs min(String field) {
        this.funSet(field + "_min", field, "min");
        return this;
    }

    public EsAggs count(String field) {
        this.funSet(field + "_count", field, "value_count");
        return this;
    }

    public EsAggs topHits(int size) {
        return this.topHits(size, null);
    }

    public EsAggs topHits(int size, Consumer<EsSort> sort) {
        ONode top_hits = this.oNode.getOrNew("$topHits").getOrNew("top_hits");
        top_hits.set("size", (Object)size);
        if (sort != null) {
            EsSort s = new EsSort(top_hits.getOrNew("sort").asArray());
            sort.accept(s);
        }
        return this;
    }

    public EsAggs cardinality(String field) {
        this.funSet(field + "_cardinality", field, "cardinality");
        return this;
    }

    public EsAggs percentiles(String field, Number[] percents) {
        ONode oNode1 = this.getLevl2Node(field + "_percentiles").getOrNew("percentiles");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("percents").addAll(Arrays.asList(percents));
        return this;
    }

    public EsAggs percentilesRank(String field, Number[] values) {
        ONode oNode1 = this.getLevl2Node(field + "_percentilesRank").getOrNew("percentile_ranks");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("values").addAll(Arrays.asList(values));
        return this;
    }

    public EsAggs extendedStats(String field) {
        this.funSet(field + "_extendedStats", field, "extended_stats");
        return this;
    }

    public EsAggs stats(String field) {
        this.funSet(field + "_stats", field, "stats");
        return this;
    }

    public EsAggs filter(Consumer<EsCondition> condition) {
        EsCondition c = new EsCondition(this.getLevl2Node("$filter").getOrNew("filter"));
        condition.accept(c);
        return this;
    }

    public EsAggs range(String field, Consumer<EsRanges> ranges) {
        ONode oNode1 = this.getLevl2Node(field + "_range").getOrNew("range");
        oNode1.set("field", (Object)field);
        EsRanges t = new EsRanges(oNode1.getOrNew("ranges").asArray());
        ranges.accept(t);
        return this;
    }

    public EsAggs terms(String field) {
        this.terms(field, null);
        return this;
    }

    public EsAggs terms(String field, Consumer<EsTerms> terms) {
        ONode oNode1 = this.getLevl2Node(field + "_terms").getOrNew("terms");
        if (field.startsWith("$")) {
            oNode1.set("script", (Object)field.substring(1));
        } else {
            oNode1.set("field", (Object)field);
        }
        if (terms != null) {
            EsTerms t = new EsTerms(oNode1);
            terms.accept(t);
        }
        return this;
    }

    public EsAggs aggs(Consumer<EsAggs> aggs) {
        if (this.lastLevl2Node == null) {
            throw new IllegalArgumentException("There are no secondary nodes");
        }
        EsAggs c = new EsAggs(this.lastLevl2Node.getOrNew("aggs"));
        aggs.accept(c);
        return this;
    }
}

