/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.etcd.impl;

import com.google.common.base.Charsets;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.noear.solon.cloud.CloudProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    private static final Logger log = LoggerFactory.getLogger(EtcdClient.class);
    private Client real;
    private int sessionTimeout;

    public EtcdClient(CloudProps cloudProps, int sessionTimeout) {
        String[] endpoints = cloudProps.getServer().split(",");
        endpoints = this.toURI(endpoints);
        this.real = Client.builder().endpoints(endpoints).build();
        this.sessionTimeout = sessionTimeout;
    }

    public KeyValue get(String key) {
        KeyValue kv = null;
        try {
            KV kvClient = this.real.getKVClient();
            ByteSequence byteKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
            CompletableFuture getFuture = kvClient.get(byteKey);
            GetResponse response = (GetResponse)getFuture.get();
            if (response.getKvs().size() > 0) {
                kv = (KeyValue)response.getKvs().get(0);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return kv;
    }

    public String getValueString(String key) {
        return this.get(key).getValue().toString(Charsets.UTF_8);
    }

    public List<KeyValue> getByPrefix(String key) throws ExecutionException, InterruptedException {
        ByteSequence byteKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        CompletableFuture getResponseCompletableFuture = this.real.getKVClient().get(ByteSequence.from((String)key, (Charset)Charsets.UTF_8), GetOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)Charsets.UTF_8)).build());
        return ((GetResponse)getResponseCompletableFuture.get()).getKvs();
    }

    public boolean put(String key, String value) {
        try {
            this.real.getKVClient().put(ByteSequence.from((String)key, (Charset)Charsets.UTF_8), ByteSequence.from((String)value, (Charset)Charsets.UTF_8)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
        return true;
    }

    public void putWithLease(final String key, String value) {
        Lease leaseClient = this.real.getLeaseClient();
        leaseClient.grant((long)this.sessionTimeout).thenAccept(result -> {
            long leaseId = result.getID();
            KV kvClient = this.real.getKVClient();
            PutOption putOption = PutOption.newBuilder().withLeaseId(leaseId).build();
            kvClient.put(ByteSequence.from((String)key, (Charset)Charsets.UTF_8), ByteSequence.from((String)value, (Charset)Charsets.UTF_8), putOption).thenAccept(putResponse -> leaseClient.keepAlive(leaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse value) {
                    log.debug("Etcd key lease renewal completed: {}", (Object)key);
                }

                public void onError(Throwable t) {
                    log.error(t.getMessage(), t);
                }

                public void onCompleted() {
                }
            }));
        });
    }

    public boolean remove(String key) {
        try {
            this.real.getKVClient().delete(ByteSequence.from((String)key, (Charset)Charsets.UTF_8)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
        return true;
    }

    public void attentionKey(String key, Watch.Listener listener) {
        this.real.getWatchClient().watch(ByteSequence.from((String)key, (Charset)Charsets.UTF_8), listener);
    }

    public void attentionKeysWithPrefix(String prefix, Watch.Listener listener) {
        WatchOption watchOpts = WatchOption.newBuilder().withPrefix(ByteSequence.from((String)prefix, (Charset)Charsets.UTF_8)).build();
        this.real.getWatchClient().watch(ByteSequence.from((String)prefix, (Charset)Charsets.UTF_8), watchOpts, listener);
    }

    public void close() {
        if (this.real != null) {
            this.real.close();
        }
    }

    public String[] toURI(String[] endpoints) {
        for (int i = 0; i < endpoints.length; ++i) {
            if (endpoints[i].startsWith("http")) continue;
            endpoints[i] = "http://" + endpoints[i];
        }
        return endpoints;
    }
}

