/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.etcd.service;

import com.google.common.base.Charsets;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.watch.WatchEvent;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.etcd.impl.EtcdClient;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigServiceEtcdImpl
implements CloudConfigService {
    private static final Logger log = LoggerFactory.getLogger(CloudConfigServiceEtcdImpl.class);
    private static final String PATH_ROOT = "/solon/config";
    private EtcdClient client;

    public CloudConfigServiceEtcdImpl(CloudProps cloudProps) {
        String sessionTimeout = cloudProps.getConfigRefreshInterval("60");
        this.client = new EtcdClient(cloudProps, Integer.parseInt(sessionTimeout));
    }

    public Config pull(String group, String name) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        String key = String.format("%s/%s/%s", PATH_ROOT, group, name);
        KeyValue kv = this.client.get(key);
        String value = null;
        long version = 0L;
        if (!Objects.isNull(kv)) {
            value = kv.getValue().toString(Charsets.UTF_8);
            version = kv.getVersion();
        }
        return new Config(group, name, value, version);
    }

    public boolean push(String group, String name, String value) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        String key = String.format("%s/%s/%s", PATH_ROOT, group, name);
        return this.client.put(key, value);
    }

    public boolean remove(String group, String name) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        String key = String.format("%s/%s/%s", PATH_ROOT, group, name);
        return this.client.remove(key);
    }

    public void attention(String group, String name, CloudConfigHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, name, observer);
        String key = String.format("%s/%s/%s", PATH_ROOT, group, name);
        Watch.Listener listener = Watch.listener(watchResponse -> watchResponse.getEvents().forEach(watchEvent -> {
            WatchEvent.EventType eventType = watchEvent.getEventType();
            log.debug("Etcd key has changed: {}", (Object)key);
            switch (eventType) {
                case PUT: {
                    observer.handle(this.pull(entity.key));
                    break;
                }
                case DELETE: {
                    observer.handle(new Config(entity.group, entity.key, null, 0L));
                }
            }
        }));
        this.client.attentionKey(key, listener);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

