/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.etcd.service;

import com.google.common.base.Charsets;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.watch.WatchEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.etcd.impl.EtcdClient;
import org.noear.solon.cloud.extend.etcd.service.CloudConfigServiceEtcdImpl;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudDiscoveryServiceEtcdImpl
implements CloudDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(CloudConfigServiceEtcdImpl.class);
    private static final String PATH_ROOT = "/solon/register";
    private EtcdClient client;

    public CloudDiscoveryServiceEtcdImpl(CloudProps cloudProps) {
        String sessionTimeout = cloudProps.getDiscoveryHealthCheckInterval("60");
        this.client = new EtcdClient(cloudProps, Integer.parseInt(sessionTimeout));
    }

    public void register(String group, Instance instance) {
        if (!Solon.cfg().appEnabled()) {
            return;
        }
        this.registerState(group, instance, true);
    }

    public void registerState(String group, Instance instance, boolean health) {
        if (health) {
            String info = ONode.stringify((Object)instance);
            String key = String.format("%s/%s/%s/%s", PATH_ROOT, group, instance.service(), instance.address());
            this.client.putWithLease(key, info);
        } else {
            this.deregister(group, instance);
        }
    }

    public void deregister(String group, Instance instance) {
        String key = String.format("%s/%s/%s/%s", PATH_ROOT, group, instance.service(), instance.address());
        this.client.remove(key);
    }

    public Discovery find(String group, String service) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        Discovery discovery = new Discovery(group, service);
        String key = String.format("%s/%s/%s", PATH_ROOT, group, service);
        List<KeyValue> instances = null;
        try {
            instances = this.client.getByPrefix(key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (KeyValue kv : instances) {
            String info = kv.getValue().toString(Charsets.UTF_8);
            Instance instance = (Instance)ONode.deserialize((String)info, Instance.class);
            discovery.instanceAdd(instance);
        }
        return discovery;
    }

    public Collection<String> findServices(String group) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        String key = String.format("%s/%s", PATH_ROOT, group);
        List<KeyValue> instances = null;
        try {
            instances = this.client.getByPrefix(key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> serviceNames = new HashSet<String>();
        for (KeyValue kv : instances) {
            String name = kv.getKey().toString(Charsets.UTF_8);
            serviceNames.add(name);
        }
        return serviceNames;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudDiscoveryObserverEntity entity = new CloudDiscoveryObserverEntity(group, service, observer);
        String prefix = String.format("%s/%s/%s", PATH_ROOT, group, service);
        Watch.Listener listener = Watch.listener(watchResponse -> watchResponse.getEvents().forEach(watchEvent -> {
            WatchEvent.EventType eventType = watchEvent.getEventType();
            log.debug("Etcd key prefix has changed: {}", (Object)prefix);
            switch (eventType) {
                case PUT: 
                case DELETE: {
                    entity.handle(this.find(entity.group, service));
                }
            }
        }));
        this.client.attentionKeysWithPrefix(prefix, listener);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

