/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.etcd.integration;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.etcd.service.CloudConfigServiceEtcdImpl;
import org.noear.solon.cloud.extend.etcd.service.CloudDiscoveryServiceEtcdImpl;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;

public class EtcdCloudPlugin
implements Plugin {
    CloudConfigServiceEtcdImpl configServiceEtcdImp;
    CloudDiscoveryServiceEtcdImpl discoveryServiceEtcdImp;

    public void start(AppContext context) throws Throwable {
        CloudProps cloudProps = new CloudProps(context, "etcd");
        if (Utils.isEmpty((String)cloudProps.getServer())) {
            return;
        }
        if (cloudProps.getConfigEnable()) {
            this.configServiceEtcdImp = new CloudConfigServiceEtcdImpl(cloudProps);
            CloudManager.register((CloudConfigService)this.configServiceEtcdImp);
            CloudClient.configLoad((String)cloudProps.getConfigLoad());
        }
        if (cloudProps.getDiscoveryEnable()) {
            this.discoveryServiceEtcdImp = new CloudDiscoveryServiceEtcdImpl(cloudProps);
            CloudManager.register((CloudDiscoveryService)this.discoveryServiceEtcdImp);
        }
    }

    public void stop() throws Throwable {
        if (this.configServiceEtcdImp != null) {
            this.configServiceEtcdImp.close();
        }
        if (this.discoveryServiceEtcdImp != null) {
            this.discoveryServiceEtcdImp.close();
        }
    }
}

