/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.fastdfs.service;

import java.time.Duration;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Props;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceFastDFSImpl
implements CloudFileService {
    private static final String DEF_CONFIG_FILE = "META-INF/solon_def/fastdfs_def.properties";
    private final String bucketDef;
    private final StorageClient client;

    public StorageClient getClient() {
        return this.client;
    }

    public CloudFileServiceFastDFSImpl(AppContext appContext, CloudProps cloudProps) {
        String secret_key;
        this.bucketDef = cloudProps.getFileBucket();
        Properties props = Utils.loadProperties((String)DEF_CONFIG_FILE);
        Props propsTmp = appContext.cfg().getProp("fastdfs");
        propsTmp.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> props.put("fastdfs." + key, val)));
        String servers = cloudProps.getFileEndpoint();
        if (Utils.isNotEmpty((String)servers)) {
            props.setProperty("fastdfs.tracker_servers", servers);
        }
        if (Utils.isNotEmpty((String)(secret_key = cloudProps.getFileSecretKey()))) {
            props.setProperty("fastdfs.http_secret_key", secret_key);
        }
        try {
            ClientGlobal.initByProperties((Properties)props);
            TrackerClient trackerClient = new TrackerClient();
            TrackerServer trackerServer = trackerClient.getTrackerServer();
            StorageServer storageServer = trackerClient.getStoreStorage(trackerServer);
            this.client = new StorageClient(trackerServer, storageServer);
        }
        catch (Exception e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public boolean exists(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            FileInfo fileInfo = this.client.get_file_info(bucket, key);
            return fileInfo != null && fileInfo.getFileSize() > 0L;
        }
        catch (Exception e) {
            throw new CloudFileException("Cloud file get failure: " + key, (Throwable)e);
        }
    }

    public String getTempUrl(String bucket, String key, Duration duration) throws CloudFileException {
        throw new UnsupportedOperationException();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            byte[] resultByte = this.client.download_file(bucket, key);
            return new Media(resultByte);
        }
        catch (Exception e) {
            throw new CloudFileException("Cloud file get failure: " + key, (Throwable)e);
        }
    }

    public Result<Object> put(String bucket, String key, Media media) throws CloudFileException {
        String[] result;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        String sufName = null;
        int sufIdx = key.lastIndexOf(".");
        if (sufIdx > 0) {
            sufName = key.substring(sufIdx + 1);
        }
        if (Utils.isEmpty(sufName)) {
            throw new CloudFileException("the file extension must not be empty: " + key);
        }
        try {
            result = this.client.upload_file(bucket, media.bodyAsBytes(), sufName, null);
        }
        catch (Exception e) {
            throw new CloudFileException("Cloud file put failure: " + key, (Throwable)e);
        }
        if (result == null) {
            throw new CloudFileException("Cloud file put failure code[" + this.client.getErrorCode() + "]: " + key);
        }
        return Result.succeed((Object)result);
    }

    public Result<Object> delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            int tmp = this.client.delete_file(bucket, key);
            return Result.succeed((Object)tmp);
        }
        catch (Exception e) {
            throw new CloudFileException("Cloud file delete failure: " + key, (Throwable)e);
        }
    }
}

