/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.folkmq.impl;

import java.io.IOException;
import org.noear.folkmq.client.IMqMessageReceived;
import org.noear.folkmq.client.MqConsumeHandler;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.folkmq.FolkmqProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolkmqConsumeHandler
implements MqConsumeHandler {
    static final Logger log = LoggerFactory.getLogger(FolkmqConsumeHandler.class);
    private CloudEventObserverManger observerManger;

    public FolkmqConsumeHandler(CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
    }

    public void consume(IMqMessageReceived message) throws IOException {
        try {
            Event event = new Event(message.getTopic(), message.getContent());
            event.times(message.getTimes());
            boolean isOk = this.onReceive(event);
            message.acknowledge(isOk);
        }
        catch (Throwable e) {
            message.acknowledge(false);
            e = Utils.throwableUnwrap((Throwable)e);
            log.warn(e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean onReceive(Event event) throws Throwable {
        try {
            return this.onReceiveDo(event);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            return false;
        }
    }

    private boolean onReceiveDo(Event event) throws Throwable {
        boolean isOk = true;
        EventObserver handler = null;
        String topicNew = this.getTopicNew(event);
        handler = this.observerManger.getByTopic(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }

    private String getTopicNew(Event event) {
        return FolkmqProps.getTopicNew(event);
    }
}

