/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.folkmq.service;

import java.io.IOException;
import org.noear.folkmq.FolkMQ;
import org.noear.folkmq.client.MqClient;
import org.noear.folkmq.client.MqConsumeHandler;
import org.noear.folkmq.client.MqMessage;
import org.noear.folkmq.client.MqTransactionCheckback;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.folkmq.FolkmqProps;
import org.noear.solon.cloud.extend.folkmq.impl.FolkmqConsumeHandler;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.event.EventBus;

public class CloudEventServiceFolkMqImpl
implements CloudEventServicePlus {
    protected final MqClient client;
    private final CloudProps cloudProps;
    private final FolkmqConsumeHandler folkmqConsumeHandler;
    private final CloudEventObserverManger observerManger;
    private final long publishTimeout;
    private String channel;
    private String group;

    public CloudEventServiceFolkMqImpl(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.observerManger = new CloudEventObserverManger();
        this.folkmqConsumeHandler = new FolkmqConsumeHandler(this.observerManger);
        this.publishTimeout = cloudProps.getEventPublishTimeout();
        this.client = FolkMQ.createClient((String[])new String[]{cloudProps.getEventServer()}).nameAs(Solon.cfg().appName()).autoAcknowledge(false);
        if (this.publishTimeout > 0L) {
            this.client.config(c -> {
                ClientConfig cfr_ignored_0 = (ClientConfig)c.requestTimeout(this.publishTimeout);
            });
        }
        EventBus.publish((Object)this.client);
        Solon.context().wrapAndPut(MqClient.class, (Object)this.client);
        Solon.context().getBeanAsync(MqTransactionCheckback.class, bean -> this.client.transactionCheckback(bean));
        try {
            this.client.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        String topicNew = FolkmqProps.getTopicNew(event);
        try {
            MqMessage message = new MqMessage(event.content()).scheduled(event.scheduled()).qos(event.qos());
            if (this.publishTimeout > 0L) {
                this.client.publish(topicNew, message);
            } else {
                this.client.publishAsync(topicNew, message);
            }
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
        return true;
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void subscribe() throws IOException {
        if (this.observerManger.topicSize() > 0) {
            Instance instance = Instance.local();
            for (String topicNew : this.observerManger.topicAll()) {
                this.client.subscribe(topicNew, instance.service(), (MqConsumeHandler)this.folkmqConsumeHandler);
            }
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

