/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.solon;

import org.noear.folkmq.client.MqAlarm;
import org.noear.folkmq.client.MqConsumeListener;
import org.noear.folkmq.client.MqMessageReceived;
import org.noear.folkmq.client.MqMessageReceivedImpl;
import org.noear.folkmq.solon.MqSolonContext;
import org.noear.socketd.transport.core.Entity;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqSolonListener
implements MqConsumeListener {
    private static final Logger log = LoggerFactory.getLogger(MqSolonListener.class);

    public void consume(MqMessageReceived message) throws Exception {
        if (Utils.isEmpty((String)message.getTag())) {
            log.warn("This message is missing route, key={}", (Object)message.getKey());
            return;
        }
        try {
            MqSolonContext ctx = new MqSolonContext((MqMessageReceivedImpl)message);
            Solon.app().tryHandle((Context)ctx);
            if (ctx.getHandled() || ctx.status() != 404) {
                ctx.commit();
            } else {
                message.response((Entity)new MqAlarm("No message handler found! like code=404"));
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            message.response((Entity)new MqAlarm("Message handler error: " + e.getMessage()));
        }
    }
}

