/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.solon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Map;
import org.noear.folkmq.client.MqAlarm;
import org.noear.folkmq.client.MqMessageReceivedImpl;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.FileEntity;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.SessionStateEmpty;
import org.noear.solon.core.util.IoUtil;

public class MqSolonContext
extends ContextEmpty {
    private MqMessageReceivedImpl _request;
    private EntityDefault _response;
    private MethodType _method;
    private URI _uri;
    private InputStream bodyAsStream;
    ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();

    public MqSolonContext(MqMessageReceivedImpl message) throws IOException {
        this._request = message;
        this._response = new EntityDefault();
        this._method = MethodType.SOCKET;
        if (Utils.isNotEmpty((String)message.getBodyAsString())) {
            for (Map.Entry kv : message.getSource().metaMap().entrySet()) {
                if (!((String)kv.getKey()).startsWith("!")) continue;
                this.headerMap().put(((String)kv.getKey()).substring(1), kv.getValue());
            }
        }
        this.sessionState = new SessionStateEmpty();
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        throw new UnsupportedOperationException();
    }

    public int remotePort() {
        throw new UnsupportedOperationException();
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return this._method.name;
    }

    public String protocol() {
        return "folkmq";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String url() {
        return this._request.getTag();
    }

    public long contentLength() {
        return this._request.getSource().dataSize();
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String queryString() {
        return this.uri().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new ByteArrayInputStream(this._request.getSource().dataAsBytes());
        }
        return this.bodyAsStream;
    }

    public Object response() {
        return this._response;
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public void headerSet(String key, String val) {
        this._response.metaPut(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.metaPut(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.meta(name);
    }

    public OutputStream outputStream() {
        return this._outputStream;
    }

    public void output(byte[] bytes) {
        try {
            this.outputStream().write(bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            IoUtil.transferTo((InputStream)stream, (OutputStream)this.outputStream());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void outputAsFile(File file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        String contentType = Utils.mime((String)file.getName());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(contentType);
        long len = file.length();
        FileEntity fileEntity = new FileEntity(file);
        this.replyDo(fileEntity.data(), (int)len);
        fileEntity.release();
    }

    public void outputAsFile(DownloadedFile file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(file.getContentType());
        byte[] bytes = IoUtil.transferToBytes((InputStream)file.getContent());
        this.replyDo(ByteBuffer.wrap(bytes), (int)file.getContentSize());
    }

    protected void commit() throws IOException {
        this.replyDo(ByteBuffer.wrap(this._outputStream.toByteArray()), this._outputStream.size());
    }

    private void replyDo(ByteBuffer dataStream, int dataSize) throws IOException {
        if (dataSize > 0 || this.status() == 200) {
            this._response.dataSet(dataStream);
            this._request.response((Entity)this._response);
        } else if (this.errors == null) {
            this._request.response((Entity)new MqAlarm("Service status code: " + this.status()));
        } else {
            this._request.response((Entity)new MqAlarm(this.errors.getMessage()));
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncListener(ContextAsyncListener listener) {
    }

    public void asyncStart(long timeout, Runnable runnable) {
    }

    public void asyncStart(long timeout, ContextAsyncListener listener, Runnable runnable) {
    }

    public void asyncComplete() {
    }

    public void close() throws IOException {
    }
}

