/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.io.IOException;
import org.noear.folkmq.client.MqClientInternal;
import org.noear.folkmq.client.MqMessage;
import org.noear.socketd.transport.core.Message;

public class MqMessageImpl
implements MqMessage {
    private final transient MqClientInternal clientInternal;
    private final transient Message from;
    private final String tid;
    private final String topic;
    private final int times;
    private final String content;

    public MqMessageImpl(MqClientInternal clientInternal, Message from) {
        this.clientInternal = clientInternal;
        this.from = from;
        this.tid = from.metaOrDefault("mq.tid", "");
        this.topic = from.metaOrDefault("mq.topic", "");
        this.times = Integer.parseInt(from.metaOrDefault("mq.times", "0"));
        this.content = from.dataAsString();
    }

    @Override
    public String getTid() {
        return this.tid;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getTimes() {
        return this.times;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void acknowledge(boolean isOk) throws IOException {
        this.clientInternal.acknowledge(this.from, isOk);
    }

    public String toString() {
        return "MqMessage{id='" + this.tid + '\'' + ", topic='" + this.topic + '\'' + ", times=" + this.times + ", content='" + this.content + '\'' + '}';
    }
}

