/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.io.IOException;
import java.util.Date;
import org.noear.folkmq.client.MqClientInternal;
import org.noear.folkmq.client.MqMessageReceived;
import org.noear.socketd.transport.core.Message;

public class MqMessageReceivedImpl
implements MqMessageReceived {
    protected final transient MqClientInternal clientInternal;
    protected final transient Message from;
    private final String tid;
    private final String topic;
    private final String content;
    private final Date scheduled;
    private final int qos;
    private final int times;

    public MqMessageReceivedImpl(MqClientInternal clientInternal, Message from) {
        this.clientInternal = clientInternal;
        this.from = from;
        this.tid = from.metaOrDefault("mq.tid", "");
        this.topic = from.metaOrDefault("mq.topic", "");
        this.content = from.dataAsString();
        this.qos = Integer.parseInt(from.metaOrDefault("mq.qos", "1"));
        this.times = Integer.parseInt(from.metaOrDefault("mq.times", "0"));
        this.scheduled = null;
    }

    public String getConsumer() {
        return this.from.meta("mq.consumer");
    }

    @Override
    public String getTid() {
        return this.tid;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Date getScheduled() {
        return null;
    }

    @Override
    public int getQos() {
        return this.qos;
    }

    @Override
    public int getTimes() {
        return this.times;
    }

    @Override
    public void acknowledge(boolean isOk) throws IOException {
        this.clientInternal.acknowledge(this, isOk);
    }

    public String toString() {
        return "MqMessage{tid='" + this.tid + '\'' + ", topic='" + this.topic + '\'' + ", content='" + this.content + '\'' + ", qos=" + this.qos + ", times=" + this.times + '}';
    }
}

