/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.io.IOException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.folkmq.server.MqNextTime;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.entity.EntityDefault;

public class MqMessageHolder
implements Delayed {
    private final EntityDefault content;
    private final String tid;
    private final int qos;
    private long distributeTime;
    private int distributeCount;
    private AtomicBoolean isDone;

    public MqMessageHolder(String consumer, Message from, String tid, int qos, int distributeCount, long distributeTime) {
        this.content = new EntityDefault().data(from.data()).metaMap(from.metaMap());
        this.content.meta("mq.consumer", consumer).at(consumer);
        this.isDone = new AtomicBoolean();
        this.tid = tid;
        this.qos = qos;
        this.distributeCount = distributeCount;
        this.distributeTime = distributeTime;
    }

    public String getTid() {
        return this.tid;
    }

    public EntityDefault getContent() throws IOException {
        return this.content;
    }

    public int getQos() {
        return this.qos;
    }

    public void setDistributeTime(long distributeTime) {
        this.distributeTime = distributeTime;
    }

    public long getDistributeTime() {
        return this.distributeTime;
    }

    public int getDistributeCount() {
        return this.distributeCount;
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    public void setDone(boolean done) {
        this.isDone.set(done);
    }

    public MqMessageHolder delayed() {
        ++this.distributeCount;
        this.distributeTime = MqNextTime.getNextTime(this);
        this.content.meta("mq.times", String.valueOf(this.distributeCount));
        this.content.meta("mq.scheduled", String.valueOf(this.distributeTime));
        return this;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.distributeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long f = this.distributeTime - ((MqMessageHolder)o).distributeTime;
        return (int)f;
    }
}

