/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.LongAdder;
import org.noear.folkmq.server.MqMessageHolder;
import org.noear.folkmq.server.MqTopicConsumerQueue;
import org.noear.socketd.transport.core.Session;

public abstract class MqTopicConsumerQueueBase
implements MqTopicConsumerQueue {
    private final Object SESSION_LOCK = new Object();
    private final List<Session> consumerSessions = new Vector<Session>();
    private final LongAdder[] messageCounters = new LongAdder[9];
    private int sessionRoundIdx;

    public MqTopicConsumerQueueBase() {
        for (int i = 0; i < this.messageCounters.length; ++i) {
            this.messageCounters[i] = new LongAdder();
        }
    }

    public void messageCounterAdd(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this.messageCounters[8].increment();
        } else {
            this.messageCounters[n].increment();
        }
    }

    public void messageCounterSub(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this.messageCounters[8].decrement();
        } else {
            this.messageCounters[n].decrement();
        }
    }

    public long messageCounter(int n) {
        if (n > 7) {
            return this.messageCounters[8].longValue();
        }
        return this.messageCounters[n].longValue();
    }

    @Override
    public int sessionCount() {
        return this.consumerSessions.size();
    }

    @Override
    public void addSession(Session session) {
        this.consumerSessions.add(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(Session session) {
        Object object = this.SESSION_LOCK;
        synchronized (object) {
            this.consumerSessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() {
        Object object = this.SESSION_LOCK;
        synchronized (object) {
            int idx = 0;
            if (this.consumerSessions.size() > 1) {
                ++this.sessionRoundIdx;
                idx = this.sessionRoundIdx % this.consumerSessions.size();
                if (this.sessionRoundIdx > 999999999) {
                    this.sessionRoundIdx = 0;
                }
            }
            return this.consumerSessions.get(idx);
        }
    }

    @Override
    public void close() {
        this.consumerSessions.clear();
    }
}

