/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.solon;

import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.interceptor.Interceptor;
import org.noear.solon.Solon;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;

public class UpstreamInterceptor
implements Interceptor {
    public boolean beforeExecute(ForestRequest request) {
        if ("upstream".equals(request.getScheme())) {
            LoadBalance loadBalance = Bridge.upstreamFactory().create("", request.host());
            if (loadBalance == null) {
                loadBalance = (LoadBalance)Solon.context().getBean(request.host());
            }
            if (loadBalance == null) {
                throw new IllegalStateException("ForestClient: Not found upstream: " + request.host());
            }
            String server = loadBalance.getServer();
            if (server == null) {
                throw new IllegalStateException("NamiClient: Upstream(" + request.host() + ") not found server!");
            }
            int idx = server.indexOf("://");
            request.setScheme(server.substring(0, idx));
            request.setHost(server.substring(idx + 3));
        }
        return true;
    }
}

