/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.solon.integration;

import com.dtflys.forest.Forest;
import com.dtflys.forest.annotation.BindingVar;
import com.dtflys.forest.annotation.ForestClient;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.SolonForestProperties;
import com.dtflys.forest.interceptor.SolonInterceptorFactory;
import com.dtflys.forest.reflection.ForestVariableValue;
import com.dtflys.forest.reflection.SolonObjectFactory;
import com.dtflys.forest.solon.ForestBeanBuilder;
import com.dtflys.forest.solon.SolonForestVariableValue;
import com.dtflys.forest.solon.SolonUpstreamInterceptor;
import com.dtflys.forest.solon.properties.ForestConfigurationProperties;
import com.dtflys.forest.utils.StringUtils;
import java.util.Arrays;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) {
        ForestConfiguration configuration = this.configBeanInit(context);
        context.beanBuilderAdd(ForestClient.class, (clz, wrap, anno) -> {
            Object client = configuration.client(clz);
            wrap.context().wrapAndPut(clz, client);
        });
        context.beanExtractorAdd(BindingVar.class, (bw, method, anno) -> {
            String confId = anno.configuration();
            ForestConfiguration config = null;
            config = StringUtils.isNotBlank((String)confId) ? Forest.config((String)confId) : configuration;
            String varName = anno.value();
            SolonForestVariableValue variableValue = new SolonForestVariableValue(bw.get(), method);
            config.setVariableValue(varName, (ForestVariableValue)variableValue);
        });
    }

    private ForestConfiguration configBeanInit(AopContext context) {
        Props forestProps = context.getProps().getProp("forest");
        ForestConfigurationProperties configurationProperties = new ForestConfigurationProperties();
        Utils.injectProperties((Object)configurationProperties, (Properties)forestProps);
        ForestBeanBuilder forestBeanBuilder = new ForestBeanBuilder(configurationProperties, new SolonForestProperties(context), new SolonObjectFactory(context), new SolonInterceptorFactory(context));
        ForestConfiguration config = forestBeanBuilder.build();
        if (config.getInterceptors() != null) {
            config.getInterceptors().add(SolonUpstreamInterceptor.class);
        } else {
            config.setInterceptors(Arrays.asList(SolonUpstreamInterceptor.class));
        }
        BeanWrap beanWrap = context.wrap(configurationProperties.getBeanId(), (Object)config);
        context.putWrap(ForestConfiguration.class, beanWrap);
        context.putWrap(configurationProperties.getBeanId(), beanWrap);
        return config;
    }
}

