/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.solon;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.ForestProperties;
import com.dtflys.forest.config.SolonForestProperties;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.auto.DefaultAutoConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.InterceptorFactory;
import com.dtflys.forest.interceptor.SolonInterceptorFactory;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.reflection.ForestObjectFactory;
import com.dtflys.forest.reflection.SolonObjectFactory;
import com.dtflys.forest.solon.properties.ForestConfigurationProperties;
import com.dtflys.forest.solon.properties.ForestConvertProperties;
import com.dtflys.forest.solon.properties.ForestConverterItemProperties;
import com.dtflys.forest.solon.properties.ForestSSLKeyStoreProperties;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.ssl.SSLSocketFactoryBuilder;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;

public class ForestBeanBuilder {
    private SolonForestProperties properties;
    private SolonObjectFactory forestObjectFactory;
    private SolonInterceptorFactory forestInterceptorFactory;
    private ForestConfigurationProperties forestConfigurationProperties;

    public ForestBeanBuilder(ForestConfigurationProperties forestConfigurationProperties, SolonForestProperties properties, SolonObjectFactory forestObjectFactory, SolonInterceptorFactory forestInterceptorFactory) {
        this.forestConfigurationProperties = forestConfigurationProperties;
        this.properties = properties;
        this.forestObjectFactory = forestObjectFactory;
        this.forestInterceptorFactory = forestInterceptorFactory;
    }

    public ForestConfiguration build() {
        String id = this.forestConfigurationProperties.getBeanId();
        if (StringUtils.isBlank((String)id)) {
            id = "forestConfiguration";
            this.forestConfigurationProperties.setBeanId(id);
        }
        ForestConfiguration forestConfiguration = ForestConfiguration.createConfiguration();
        Class<? extends ForestLogHandler> logHandlerClass = this.forestConfigurationProperties.getLogHandler();
        ForestLogHandler logHandler = null;
        if (logHandlerClass != null) {
            try {
                logHandler = logHandlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
        }
        forestConfiguration.setMaxAsyncThreadSize(Integer.valueOf(this.forestConfigurationProperties.getMaxAsyncThreadSize()));
        forestConfiguration.setMaxAsyncQueueSize(Integer.valueOf(this.forestConfigurationProperties.getMaxAsyncQueueSize()));
        forestConfiguration.setMaxConnections(Integer.valueOf(this.forestConfigurationProperties.getMaxConnections()));
        forestConfiguration.setMaxRouteConnections(Integer.valueOf(this.forestConfigurationProperties.getMaxRouteConnections()));
        forestConfiguration.setAsyncMode(this.forestConfigurationProperties.getAsyncMode());
        forestConfiguration.setTimeout(Integer.valueOf(this.forestConfigurationProperties.getTimeout()));
        forestConfiguration.setConnectTimeout(this.forestConfigurationProperties.getConnectTimeoutMillis());
        forestConfiguration.setReadTimeout(this.forestConfigurationProperties.getReadTimeoutMillis());
        forestConfiguration.setCharset(this.forestConfigurationProperties.getCharset());
        forestConfiguration.setRetryer(this.forestConfigurationProperties.getRetryer());
        forestConfiguration.setMaxRetryCount(Integer.valueOf(this.forestConfigurationProperties.getMaxRetryCount()));
        forestConfiguration.setMaxRetryInterval(this.forestConfigurationProperties.getMaxRetryInterval());
        forestConfiguration.setAutoRedirection(this.forestConfigurationProperties.isAutoRedirection());
        forestConfiguration.setLogEnabled(this.forestConfigurationProperties.isLogEnabled());
        forestConfiguration.setLogRequest(this.forestConfigurationProperties.isLogRequest());
        forestConfiguration.setLogResponseStatus(this.forestConfigurationProperties.isLogResponseStatus());
        forestConfiguration.setLogResponseContent(this.forestConfigurationProperties.isLogResponseContent());
        forestConfiguration.setLogHandler(logHandler);
        forestConfiguration.setBackendName(this.forestConfigurationProperties.getBackend());
        forestConfiguration.setBaseAddressScheme(this.forestConfigurationProperties.getBaseAddressScheme());
        forestConfiguration.setBaseAddressHost(this.forestConfigurationProperties.getBaseAddressHost());
        forestConfiguration.setBaseAddressPort(this.forestConfigurationProperties.getBaseAddressPort());
        forestConfiguration.setBaseAddressSourceClass(this.forestConfigurationProperties.getBaseAddressSource());
        forestConfiguration.setSuccessWhenClass(this.forestConfigurationProperties.getSuccessWhen());
        forestConfiguration.setRetryWhenClass(this.forestConfigurationProperties.getRetryWhen());
        forestConfiguration.setInterceptors(this.forestConfigurationProperties.getInterceptors());
        forestConfiguration.setSslProtocol(this.forestConfigurationProperties.getSslProtocol());
        forestConfiguration.setVariables(this.forestConfigurationProperties.getVariables());
        List<ForestSSLKeyStoreProperties> sslKeyStorePropertiesList = this.forestConfigurationProperties.getSslKeyStores();
        LinkedHashMap<String, SSLKeyStore> sslKeystoreMap = new LinkedHashMap<String, SSLKeyStore>();
        for (ForestSSLKeyStoreProperties keyStoreProperties : sslKeyStorePropertiesList) {
            this.registerSSLKeyStoreBean(sslKeystoreMap, keyStoreProperties);
        }
        forestConfiguration.setSslKeyStores(sslKeystoreMap);
        ForestConfiguration configuration = forestConfiguration;
        configuration.setProperties((ForestProperties)this.properties);
        configuration.setForestObjectFactory((ForestObjectFactory)this.forestObjectFactory);
        configuration.setInterceptorFactory((InterceptorFactory)this.forestInterceptorFactory);
        Map<String, Class> filters = this.forestConfigurationProperties.getFilters();
        for (Map.Entry<String, Class> entry : filters.entrySet()) {
            String filterName = entry.getKey();
            Class filterClass = entry.getValue();
            configuration.registerFilter(filterName, filterClass);
        }
        ForestConvertProperties convertProperties = this.forestConfigurationProperties.getConverters();
        if (convertProperties != null) {
            this.registerConverter(configuration, ForestDataType.TEXT, convertProperties.getText());
            this.registerConverter(configuration, ForestDataType.JSON, convertProperties.getJson());
            this.registerConverter(configuration, ForestDataType.XML, convertProperties.getXml());
            this.registerConverter(configuration, ForestDataType.BINARY, convertProperties.getBinary());
            this.registerConverter(configuration, ForestDataType.PROTOBUF, convertProperties.getProtobuf());
        }
        return configuration;
    }

    private void registerConverter(ForestConfiguration configuration, ForestDataType dataType, ForestConverterItemProperties converterItemProperties) {
        if (converterItemProperties == null) {
            return;
        }
        Class<? extends ForestConverter> type = converterItemProperties.getType();
        if (type != null) {
            ForestConverter converter = null;
            try {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = type.getConstructors()) {
                    Parameter[] params = constructor.getParameters();
                    if (params.length == 0) {
                        converter = (ForestConverter)constructor.newInstance(new Object[0]);
                        break;
                    }
                    Object[] args = new Object[params.length];
                    Class<?>[] pTypes = constructor.getParameterTypes();
                    for (int i = 0; i < params.length; ++i) {
                        Class<?> pType = pTypes[i];
                        if (ForestConfiguration.class.isAssignableFrom(pType)) {
                            args[i] = configuration;
                            continue;
                        }
                        if (!DefaultAutoConverter.class.isAssignableFrom(pType)) continue;
                        args[i] = configuration.getConverter(ForestDataType.AUTO);
                    }
                    converter = (ForestConverter)constructor.newInstance(args);
                }
                Map<String, Object> parameters = converterItemProperties.getParameters();
                ClassWrap classWrap = ClassWrap.get(type);
                for (Map.Entry kv : classWrap.getFieldAllWraps().entrySet()) {
                    String name = (String)kv.getKey();
                    Object value = parameters.get(name);
                    FieldWrap fw = (FieldWrap)kv.getValue();
                    if (value == null) continue;
                    try {
                        fw.setValue((Object)converter, value, false);
                    }
                    catch (Throwable e) {
                        e = Utils.throwableUnwrap((Throwable)e);
                        if (e instanceof IllegalAccessException) {
                            throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, e);
                        }
                        if (e instanceof InvocationTargetException) {
                            throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, e);
                        }
                        throw new RuntimeException(e);
                    }
                }
                configuration.getConverterMap().put(dataType, converter);
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
        }
    }

    public void registerSSLKeyStoreBean(Map<String, SSLKeyStore> map, ForestSSLKeyStoreProperties sslKeyStoreProperties) {
        String id = sslKeyStoreProperties.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new ForestRuntimeException("[Forest] Property 'id' of SSL keystore can not be empty or blank");
        }
        if (map.containsKey(id)) {
            throw new ForestRuntimeException("[Forest] Duplicate SSL keystore id '" + id + "'");
        }
        SSLKeyStore sslKeyStore = ForestBeanBuilder.createSSLKeyStoreBean(id, sslKeyStoreProperties.getType(), sslKeyStoreProperties.getFile(), sslKeyStoreProperties.getKeystorePass(), sslKeyStoreProperties.getCertPass(), sslKeyStoreProperties.getProtocols(), sslKeyStoreProperties.getCipherSuites(), sslKeyStoreProperties.getTrustManager(), sslKeyStoreProperties.getHostnameVerifier(), sslKeyStoreProperties.getSslSocketFactoryBuilder());
        map.put(id, sslKeyStore);
    }

    public static SSLKeyStore createSSLKeyStoreBean(String id, String keystoreType, String filePath, String keystorePass, String certPass, String protocolsStr, String cipherSuitesStr, String trustManagerClass, String hostnameVerifierClass, String sslSocketFactoryBuilderClass) {
        int i;
        String[] strs;
        TrustManager trustManager = (TrustManager)ClassUtil.newInstance((String)trustManagerClass);
        HostnameVerifier hostnameVerifier = (HostnameVerifier)ClassUtil.newInstance((String)hostnameVerifierClass);
        SSLSocketFactoryBuilder sslSocketFactoryBuilder = (SSLSocketFactoryBuilder)ClassUtil.newInstance((String)sslSocketFactoryBuilderClass);
        SSLKeyStore sslKeyStore = new SSLKeyStore(id, keystoreType, filePath, keystorePass, certPass, trustManager, hostnameVerifier, sslSocketFactoryBuilder);
        if (StringUtils.isNotEmpty((CharSequence)protocolsStr)) {
            strs = protocolsStr.split("[ /t]*,[ /t]*");
            String[] protocols = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                protocols[i] = strs[i].trim();
            }
            sslKeyStore.setProtocols(protocols);
        }
        if (StringUtils.isNotEmpty((CharSequence)cipherSuitesStr)) {
            strs = cipherSuitesStr.split("[ /t]*,[ /t]*");
            String[] cipherSuites = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                cipherSuites[i] = strs[i].trim();
            }
            sslKeyStore.setCipherSuites(cipherSuites);
        }
        return sslKeyStore;
    }
}

