/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.file;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.UploadedFile;

public class SolonMultipartFile
extends ForestMultipart<UploadedFile, SolonMultipartFile> {
    private UploadedFile multipartFile;

    public SolonMultipartFile setData(UploadedFile data) {
        this.multipartFile = data;
        return this;
    }

    public String getOriginalFileName() {
        if (StringUtils.isNotBlank((String)this.fileName)) {
            return this.fileName;
        }
        return this.multipartFile.getName();
    }

    public InputStream getInputStream() {
        return this.multipartFile.getContent();
    }

    public long getSize() {
        return this.multipartFile.getContentSize();
    }

    public boolean isFile() {
        return false;
    }

    public File getFile() {
        throw new ForestRuntimeException("[Forest] SpringMultipartFile instances are not files");
    }

    public byte[] getBytes() {
        try {
            return Utils.transferToBytes((InputStream)this.multipartFile.getContent());
        }
        catch (IOException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }
}

