/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.utils.ForestDataType;
import java.io.IOException;
import java.io.InputStream;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.UploadedFile;

public class SolonUploadRequestBody
extends ForestRequestBody {
    private UploadedFile multipartFile;

    public SolonUploadRequestBody(UploadedFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public UploadedFile getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(UploadedFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public byte[] getByteArray() {
        try {
            return Utils.transferToBytes((InputStream)this.multipartFile.getContent());
        }
        catch (IOException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    public ForestDataType getDefaultBodyType() {
        return ForestDataType.MULTIPART;
    }

    public SolonUploadRequestBody clone() {
        SolonUploadRequestBody newBody = new SolonUploadRequestBody(this.multipartFile);
        newBody.setDefaultValue(this.getDefaultValue());
        return newBody;
    }
}

