/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.solon.integration;

import com.dtflys.forest.Forest;
import com.dtflys.forest.annotation.BindingVar;
import com.dtflys.forest.annotation.ForestClient;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.SolonForestProperties;
import com.dtflys.forest.file.SolonMultipartFile;
import com.dtflys.forest.http.body.RequestBodyBuilder;
import com.dtflys.forest.http.body.SolonUploadRequestBodyBuilder;
import com.dtflys.forest.interceptor.SolonInterceptorFactory;
import com.dtflys.forest.multipart.ForestMultipartFactory;
import com.dtflys.forest.reflection.ForestVariableValue;
import com.dtflys.forest.reflection.SolonObjectFactory;
import com.dtflys.forest.solon.ForestBeanBuilder;
import com.dtflys.forest.solon.SolonForestVariableValue;
import com.dtflys.forest.solon.SolonUpstreamInterceptor;
import com.dtflys.forest.solon.properties.ForestConfigurationProperties;
import com.dtflys.forest.utils.StringUtils;
import java.util.Arrays;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.handle.UploadedFile;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) {
        ForestConfiguration configuration = this.configBeanInit(context);
        ForestMultipartFactory.registerFactory(UploadedFile.class, SolonMultipartFile.class);
        RequestBodyBuilder.registerBodyBuilder(UploadedFile.class, (RequestBodyBuilder)new SolonUploadRequestBodyBuilder());
        context.beanBuilderAdd(ForestClient.class, (clz, wrap, anno) -> {
            Object client = configuration.client(clz);
            context.wrapAndPut(clz, client);
        });
        context.beanExtractorAdd(BindingVar.class, (bw, method, anno) -> {
            String confId = anno.configuration();
            ForestConfiguration config = null;
            config = StringUtils.isNotBlank((String)confId) ? Forest.config((String)confId) : configuration;
            String varName = anno.value();
            SolonForestVariableValue variableValue = new SolonForestVariableValue(bw.get(), method);
            config.setVariableValue(varName, (ForestVariableValue)variableValue);
        });
    }

    private ForestConfiguration configBeanInit(AppContext context) {
        Props forestProps = context.cfg().getProp("forest");
        ForestConfigurationProperties configurationProperties = new ForestConfigurationProperties();
        Utils.injectProperties((Object)configurationProperties, (Properties)forestProps);
        ForestBeanBuilder forestBeanBuilder = new ForestBeanBuilder(configurationProperties, new SolonForestProperties(context), new SolonObjectFactory(context), new SolonInterceptorFactory(context));
        ForestConfiguration config = forestBeanBuilder.build();
        if (config.getInterceptors() != null) {
            config.getInterceptors().add(SolonUpstreamInterceptor.class);
        } else {
            config.setInterceptors(Arrays.asList(SolonUpstreamInterceptor.class));
        }
        String beanId = configurationProperties.getBeanId();
        if (Utils.isEmpty((String)beanId)) {
            beanId = "forestConfiguration";
        }
        BeanWrap beanWrap = context.wrap(beanId, (Object)config);
        context.putWrap(ForestConfiguration.class, beanWrap);
        context.putWrap(beanId, beanWrap);
        return config;
    }
}

