/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.solon;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.ForestVariableValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SolonForestVariableValue
implements ForestVariableValue {
    private static final Object[] DEFAULT_ARGUMENTS = new Object[0];
    private final Object bean;
    private final Method method;

    public SolonForestVariableValue(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public Object getValue(ForestMethod forestMethod) {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        try {
            if (paramTypes.length == 0) {
                return this.method.invoke(this.bean, DEFAULT_ARGUMENTS);
            }
            if (paramTypes.length == 1 && ForestMethod.class.isAssignableFrom(paramTypes[0])) {
                return this.method.invoke(this.bean, forestMethod);
            }
            throw new ForestRuntimeException("[Forest] Method '" + this.method.getName() + "' can not be binding to a Forest variable");
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }
}

