/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.GritException;
import org.noear.grit.solon.SessionBase;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.auth.AuthProcessorBase;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.core.handle.Context;

public class GritAuthProcessor2
extends AuthProcessorBase {
    protected long getSubjectId() {
        return SessionBase.global().getSubjectId();
    }

    protected String getSubjectDisplayName() {
        return SessionBase.global().getDisplayName();
    }

    public boolean verifyIp(String ip) {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        long subjectId = this.getSubjectId();
        if (subjectId > 0L) {
            String subjectDisplayName = this.getSubjectDisplayName();
            Context ctx = Context.current();
            if (ctx != null) {
                ctx.attrSet("user_puid", (Object)String.valueOf(subjectId));
                ctx.attrSet("user_name", (Object)subjectDisplayName);
                ctx.attrSet("user_id", (Object)String.valueOf(subjectId));
                ctx.attrSet("user_display_name", (Object)subjectDisplayName);
            }
        }
        if (!Solon.cfg().isWhiteMode()) {
            return true;
        }
        return CloudClient.list().inListOfClientAndServerIp(ip);
    }

    public boolean verifyLogined() {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        return this.getSubjectId() > 0L;
    }

    public boolean verifyPath(String path, String method) {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        try {
            if (!GritClient.global().resource().hasResourceByUri(path)) {
                return true;
            }
            return GritClient.global().auth().hasUri(this.getSubjectId(), path);
        }
        catch (SQLException e) {
            throw new GritException((Throwable)e);
        }
    }

    protected List<String> getPermissions() {
        List permissionList = null;
        Context ctx = Context.current();
        String sessionKey = GritClient.global().getCurrentSpaceCode() + ":user_permissionList";
        if (ctx != null) {
            permissionList = (List)ctx.session(sessionKey, null);
        }
        if (permissionList == null) {
            try {
                permissionList = GritClient.global().auth().getPermissionList(this.getSubjectId()).stream().filter(s -> Utils.isNotEmpty((String)s.resource_code)).map(s -> s.resource_code).collect(Collectors.toList());
                if (ctx != null) {
                    ctx.sessionSet(sessionKey, permissionList);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return permissionList;
    }

    protected List<String> getRoles() {
        List roleList = null;
        Context ctx = Context.current();
        String sessionKey = GritClient.global().getCurrentSpaceCode() + ":user_roleList";
        if (ctx != null) {
            roleList = (List)ctx.session(sessionKey, null);
        }
        if (roleList == null) {
            try {
                roleList = GritClient.global().auth().getRoleList(this.getSubjectId()).stream().filter(s -> Utils.isNotEmpty((String)s.subject_code)).map(s -> s.subject_code).collect(Collectors.toList());
                if (ctx != null) {
                    ctx.sessionSet(sessionKey, roleList);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return roleList;
    }
}

