/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon;

import org.noear.grit.client.GritClient;
import org.noear.grit.client.GritException;
import org.noear.grit.solon.SessionBase;
import org.noear.solon.Solon;
import org.noear.solon.auth.AuthProcessor;
import org.noear.solon.auth.annotation.Logical;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.core.handle.Context;

public class GritAuthProcessor
implements AuthProcessor {
    protected long getSubjectId() {
        return SessionBase.global().getSubjectId();
    }

    protected String getSubjectDisplayName() {
        return SessionBase.global().getDisplayName();
    }

    public boolean verifyIp(String ip) {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        long subjectId = this.getSubjectId();
        if (subjectId > 0L) {
            String subjectDisplayName = this.getSubjectDisplayName();
            Context ctx = Context.current();
            if (ctx != null) {
                ctx.attrSet("user_puid", (Object)String.valueOf(subjectId));
                ctx.attrSet("user_name", (Object)subjectDisplayName);
                ctx.attrSet("user_id", (Object)String.valueOf(subjectId));
                ctx.attrSet("user_display_name", (Object)subjectDisplayName);
            }
        }
        if (!Solon.cfg().isWhiteMode()) {
            return true;
        }
        return CloudClient.list().inListOfClientAndServerIp(ip);
    }

    public boolean verifyLogined() {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        return this.getSubjectId() > 0L;
    }

    public boolean verifyPath(String path, String method) {
        if (Solon.cfg().isSetupMode()) {
            return true;
        }
        try {
            if (!GritClient.global().resource().hasResourceByUri(path)) {
                return true;
            }
            return GritClient.global().auth().hasUri(this.getSubjectId(), path);
        }
        catch (Exception e) {
            throw new GritException((Throwable)e);
        }
    }

    public boolean verifyPermissions(String[] permissions, Logical logical) {
        long subjectId = this.getSubjectId();
        try {
            if (logical == Logical.AND) {
                boolean isOk = true;
                for (String p : permissions) {
                    isOk = isOk && GritClient.global().auth().hasPermission(subjectId, p);
                }
                return isOk;
            }
            for (String p : permissions) {
                if (!GritClient.global().auth().hasPermission(subjectId, p)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new GritException((Throwable)e);
        }
    }

    public boolean verifyRoles(String[] roles, Logical logical) {
        long subjectId = this.getSubjectId();
        try {
            if (logical == Logical.AND) {
                boolean isOk = true;
                for (String r : roles) {
                    isOk = isOk && GritClient.global().auth().hasRole(subjectId, r);
                }
                return isOk;
            }
            for (String r : roles) {
                if (!GritClient.global().auth().hasRole(subjectId, r)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new GritException((Throwable)e);
        }
    }
}

