/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon;

import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;

public abstract class SessionAbstractBase {
    protected static final String SUBJECT_ID = "subjectId";

    protected Context context() {
        return Context.current();
    }

    protected long globalSubjectId() {
        return this.globalGetAsLong(SUBJECT_ID, 0L);
    }

    protected String globalGet(String key, String def) {
        Object tmp = this.context().session(key);
        if (tmp == null) {
            return def;
        }
        return tmp.toString();
    }

    protected long globalGetAsLong(String key, long def) {
        String tmp = this.globalGet(key, String.valueOf(def));
        return Long.parseLong(tmp);
    }

    protected int globalGetAsInt(String key, int def) {
        String tmp = this.globalGet(key, String.valueOf(def));
        return Integer.parseInt(tmp);
    }

    protected void globalSet(String key, Object val) {
        if (val == null) {
            val = "";
        }
        this.context().sessionSet(key, (Object)val.toString());
    }

    protected boolean globalHas(String key) {
        return this.context().session(key) != null;
    }

    protected long localSubjectId() {
        return this.localGetAsLong(SUBJECT_ID, 0L);
    }

    public String localGet(String key, String def) {
        return this.globalGet(Solon.cfg().appName() + "_" + key, def);
    }

    public long localGetAsLong(String key, long def) {
        String tmp = this.localGet(key, String.valueOf(def));
        return Long.parseLong(tmp);
    }

    public int localGetAsInt(String key, int def) {
        String tmp = this.localGet(key, String.valueOf(def));
        return Integer.parseInt(tmp);
    }

    public void localSet(String key, Object val) {
        if (val == null) {
            val = "";
        }
        this.globalSet(Solon.cfg().appName() + "_" + key, val.toString());
    }

    public boolean localHas(String key) {
        return this.globalHas(Solon.cfg().appName() + "_" + key);
    }
}

