/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.admin.controller;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.noear.grit.Grit;
import org.noear.grit.server.GritServerConfig;
import org.noear.grit.server.admin.AdminConfig;
import org.noear.grit.server.admin.util.ImageUtils;
import org.noear.grit.server.admin.util.RandomUtils;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.annotation.Valid;

@Valid
@Singleton(value=false)
@Mapping(value="grit")
@Controller
public class GritController {
    protected ModelAndView viewModel = new ModelAndView();

    public ModelAndView view(String viewName) {
        String title = AdminConfig.title();
        this.viewModel.put("app", (Object)"Grit");
        this.viewModel.put("css", (Object)(GritServerConfig.staticPrefix() + "/css"));
        this.viewModel.put("js", (Object)(GritServerConfig.staticPrefix() + "/js"));
        this.viewModel.put("img", (Object)(GritServerConfig.staticPrefix() + "/img"));
        this.viewModel.put("title", (Object)title);
        this.viewModel.put("_version", (Object)Grit.version());
        return this.viewModel.view(viewName + ".ftl");
    }

    @Mapping(value="/")
    public ModelAndView home() {
        return this.view("grit/dock");
    }

    @Mapping(value="/login")
    public ModelAndView login(Context ctx) {
        ctx.sessionSet("grit_admin_token", (Object)"");
        return this.view("grit/login");
    }

    @Mapping(value="/login/ajax/check")
    public Result login_ajax_check(Context ctx, String admin_userName, String admin_passWord, String captcha) throws Exception {
        boolean isLogin;
        if (!captcha.toLowerCase().equals(this.getValidation(ctx))) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        if (Utils.isEmpty((String)admin_userName) || Utils.isEmpty((String)admin_passWord)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8bf7\u8f93\u5165\u8d26\u53f7\u548c\u5bc6\u7801\uff01");
        }
        String user0 = Solon.cfg().get("gritadmin.user", "admin");
        String password0 = Solon.cfg().get("gritadmin.password", "");
        boolean bl = isLogin = user0.equals(admin_userName) && password0.equals(admin_passWord);
        if (!isLogin) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u5bf9\uff01");
        }
        String admin_token = Utils.md5((String)(user0 + "#" + password0));
        ctx.sessionSet("grit_admin_token", (Object)admin_token);
        return Result.succeed((Object)"/grit/");
    }

    @Mapping(value="/login/validation/img", method={MethodType.GET}, produces="image/jpeg")
    public void getValidationImg(Context ctx) throws IOException {
        String code = RandomUtils.code(4);
        this.setValidation(ctx, code);
        BufferedImage bufferedImage = ImageUtils.getValidationImage(code);
        ctx.headerSet("Pragma", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.headerSet("Expires", "0");
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", ctx.outputStream());
    }

    protected final String getValidation(Context ctx) {
        return (String)ctx.session("grit_validation_string");
    }

    protected final void setValidation(Context ctx, String validation) {
        ctx.sessionSet("grit_validation_string", (Object)validation.toLowerCase());
    }
}

