/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon;

import org.noear.grit.client.GritClient;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.solon.SessionAbstractBase;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;

public abstract class SessionBase
extends SessionAbstractBase {
    public static final String GRIT_ADMIN_TOKEN = "grit_admin_token";
    private static SessionBase _global;

    public static SessionBase global() {
        return _global;
    }

    public SessionBase() {
        if (_global == null) {
            _global = this;
        }
    }

    public void clear() {
        Context ctx = this.context();
        if (ctx != null) {
            String adminToken = (String)ctx.session(GRIT_ADMIN_TOKEN, (Object)"");
            ctx.sessionClear();
            if (Utils.isNotEmpty((String)adminToken)) {
                ctx.sessionSet(GRIT_ADMIN_TOKEN, (Object)adminToken);
            }
        }
    }

    public void loadSubject(String loginName, String loginPassword) throws Exception {
        this.loadSubject(GritClient.global().auth().login(loginName, loginPassword));
    }

    public abstract void loadSubject(Subject var1) throws Exception;

    public final long getSubjectId() {
        long temp = this.globalSubjectId();
        if (temp > 0L && temp != this.localSubjectId()) {
            try {
                Subject subject = GritClient.global().subject().getSubjectById(temp);
                this.loadSubject(subject);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return temp;
    }

    public final void setSubjectId(long subjectId) {
        this.globalSet("subjectId", subjectId);
        this.localSet("subjectId", subjectId);
    }

    public final String getLoginName() {
        return this.globalGet("loginName", null);
    }

    public final void setLoginName(String loginName) {
        this.globalSet("loginName", loginName);
    }

    public final String getDisplayName() {
        return this.globalGet("displayName", null);
    }

    public final void setDisplayName(String displayName) {
        this.globalSet("displayName", displayName);
    }
}

