/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon.integration;

import org.noear.grit.client.GritClient;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.AppLoadEndEvent;

public class XPluginImp
implements Plugin {
    static final String GRIT_INIT_CONFIG = "grit-init.jsond";

    public void start(SolonApp app) {
        app.onEvent(AppLoadEndEvent.class, e -> {
            String appName = Solon.cfg().appName();
            if (appName != null && !"gritdock".equals(appName)) {
                this.initGritSpace(appName);
                GritClient.global().setCurrentSpaceByCode(appName);
            }
            app.get("/_session/domain.js", ctx -> {
                String domain = app.cfg().get("server.session.state.domain");
                if (!Utils.isEmpty((String)domain) && ctx.uri().getHost().indexOf(domain) >= 0) {
                    ctx.contentType("text/javascript");
                    ctx.output("try { document.domain = '" + domain + "'; }catch (err) { }");
                }
            });
        });
    }

    private void initGritSpace(String appName) throws Exception {
        String jsond = Utils.getResourceAsString((String)GRIT_INIT_CONFIG);
        if (Utils.isEmpty((String)jsond)) {
            return;
        }
        String jsond_md5 = Utils.md5((String)jsond);
        if (GritClient.global().resource().hasSpaceByCode(appName)) {
            String jsond_md5C = null;
            Config config = CloudClient.config().pull("_grit", appName);
            if (config != null) {
                jsond_md5C = config.value();
            }
            if (jsond_md5.equals(jsond_md5C)) {
                return;
            }
        }
        GritClient.global().resourceSchema().importSchema(jsond);
        CloudClient.config().push("_grit", appName, jsond_md5);
    }
}

