/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon.integration;

import org.noear.grit.client.GritClient;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.util.ResourceUtil;

public class XPluginImp
implements Plugin {
    static final String GRIT_INIT_CONFIG = "grit-init.jsond";

    public void start(AppContext context) {
        Solon.app().onEvent(AppLoadEndEvent.class, e -> {
            String appName = Solon.cfg().appName();
            if (appName != null && !"gritdock".equals(appName)) {
                this.initGritSpace(appName);
                GritClient.global().setCurrentSpaceByCode(appName);
            }
            Solon.app().get("/_session/domain.js", ctx -> {
                String domain = Solon.cfg().get("server.session.state.domain");
                if (!Utils.isEmpty((String)domain) && ctx.uri().getHost().indexOf(domain) >= 0) {
                    ctx.contentType("text/javascript");
                    ctx.output("try { document.domain = '" + domain + "'; }catch (err) { }");
                }
            });
        });
    }

    private void initGritSpace(String appName) throws Exception {
        String data = ResourceUtil.getResourceAsString((String)GRIT_INIT_CONFIG);
        if (Utils.isEmpty((String)data)) {
            return;
        }
        String data_md5 = Utils.md5((String)data);
        if (GritClient.global().resource().hasSpaceByCode(appName)) {
            String data_md5C = null;
            Config config = CloudClient.config().pull("_grit", appName);
            if (config != null) {
                data_md5C = config.value();
            }
            if (data_md5.equals(data_md5C)) {
                return;
            }
        }
        GritClient.global().resourceSchema().importSchema(data);
        CloudClient.config().push("_grit", appName, data_md5);
    }
}

