/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.solon;

import org.noear.grit.client.GritClient;
import org.noear.grit.solon.SessionBase;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public abstract class GritPathInterceptorBase
implements Handler {
    protected long getSubjectId() {
        return SessionBase.global().getSubjectId();
    }

    protected String getSubjectDisplayName() {
        return SessionBase.global().getDisplayName();
    }

    protected void verifyHandle(Context ctx) throws Exception {
        if (Solon.cfg().isSetupMode()) {
            return;
        }
        String path = ctx.path().toLowerCase();
        long subjectId = this.getSubjectId();
        if (subjectId > 0L) {
            String subjectDisplayName = this.getSubjectDisplayName();
            ctx.attrSet("user_puid", (Object)String.valueOf(subjectId));
            ctx.attrSet("user_name", (Object)subjectDisplayName);
            ctx.attrSet("user_id", (Object)String.valueOf(subjectId));
            ctx.attrSet("user_display_name", (Object)subjectDisplayName);
        }
        if (path.indexOf("/ajax/") < 0 && !path.startsWith("/login") && GritClient.global().resource().hasResourceByUri(path)) {
            if (subjectId == 0L) {
                ctx.redirect("/login");
                ctx.setHandled(true);
                return;
            }
            if (!GritClient.global().auth().hasUri(subjectId, path)) {
                ctx.outputAsHtml("Sorry, no permission!");
                ctx.setHandled(true);
                return;
            }
        }
    }

    public void handle(Context ctx) throws Throwable {
        this.verifyHandle(ctx);
    }
}

