/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.client.comparator.SubjectComparator;
import org.noear.grit.client.utils.ResourceTreeUtils;
import org.noear.grit.client.utils.SujectTreeUtils;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.model.domain.SubjectGroup;
import org.noear.grit.model.type.SubjectType;
import org.noear.grit.server.dso.ResourceSpaceCookie;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.dso.service.SubjectAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;

@Mapping(value="/grit/ui/auth")
@Controller
public class AuthController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;
    @Inject
    SubjectAdminService subjectAdminService;

    @Mapping
    public ModelAndView home(Long group_id) throws SQLException {
        List list = this.subjectAdminService.getGroupList();
        list = SujectTreeUtils.build((List)list, (long)0L);
        if (group_id == null && list.size() > 0) {
            group_id = ((SubjectGroup)list.get((int)0)).subject_id;
        }
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"list", (Object)list);
        return this.view("grit/ui/auth");
    }

    @Mapping(value="s")
    public ModelAndView auth_s() throws SQLException {
        List enityList = this.subjectAdminService.getSubjectEntityListByAll();
        enityList.sort(SubjectComparator.instance);
        this.viewModel.put((Object)"group_id", (Object)0L);
        this.viewModel.put((Object)"enityList", (Object)enityList);
        return this.view("grit/ui/auth_s");
    }

    @Mapping(value="subject.entity.get")
    public Result entity_get(long group_id) throws SQLException {
        List enityList = null;
        enityList = group_id == 0L ? this.subjectAdminService.getSubjectEntityListByAll() : this.subjectAdminService.getSubjectEntityListByGroup(group_id);
        enityList.sort(SubjectComparator.instance);
        return Result.succeed((Object)enityList);
    }

    @Mapping(value="inner")
    public ModelAndView inner(long subject_id, long space_id) throws SQLException {
        if (subject_id == 0L) {
            return null;
        }
        Subject subject = this.subjectAdminService.getSubjectById(subject_id);
        StringBuilder authRes = new StringBuilder();
        if (subject.subject_type == SubjectType.group.code) {
            this.resourceAdminService.getResourceLinkListBySubjectSlf(subject_id).stream().forEach(r -> authRes.append(r.resource_id).append(","));
        } else {
            this.resourceAdminService.getResourceLinkListBySubjectAll(subject_id).stream().forEach(r -> authRes.append(r.resource_id).append(","));
        }
        if (authRes.length() > 0) {
            authRes.setLength(authRes.length() - 1);
        }
        List spaceList = this.resourceAdminService.getSpaceList();
        spaceList.sort(ResourceComparator.instance);
        if (space_id == 0L && GritClient.global().getCurrentSpaceId() > 0L) {
            space_id = GritClient.global().getCurrentSpaceId();
        }
        space_id = ResourceSpaceCookie.build((long)space_id, (List)spaceList);
        ResourceSpaceCookie.set((long)space_id);
        List groupList = this.resourceAdminService.getResourceGroupListBySpace(space_id);
        groupList = ResourceTreeUtils.build((List)groupList, (long)space_id);
        List resourceList = this.resourceAdminService.getResourceListBySpace(space_id);
        resourceList = ResourceTreeUtils.build((List)resourceList, (long)space_id);
        this.viewModel.put((Object)"subject_id", (Object)subject_id);
        this.viewModel.put((Object)"subject", (Object)subject);
        this.viewModel.put((Object)"authRes", (Object)authRes);
        this.viewModel.put((Object)"space_id", (Object)space_id);
        this.viewModel.put((Object)"spaceList", (Object)spaceList);
        this.viewModel.put((Object)"groupList", (Object)groupList);
        this.viewModel.put((Object)"resourceList", (Object)resourceList);
        return this.view("grit/ui/auth_inner");
    }

    @Mapping(value="ajax/save")
    public Result auth_save(long subject_id, int subject_type, long space_id, String authRes) throws SQLException {
        if (subject_id == 0L) {
            return Result.failure();
        }
        this.resourceAdminService.delResourceLinkBySubjectBySpace(subject_id, space_id);
        if (Utils.isNotEmpty((String)authRes)) {
            List resIds = Arrays.stream(authRes.split(",")).map(s -> Long.parseLong(s)).collect(Collectors.toList());
            this.resourceAdminService.addResourceLinkBySubject(subject_id, subject_type, resIds);
        }
        return Result.succeed();
    }
}

