/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.client.utils.ResourceTreeUtils;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.server.dso.ResourceSpaceCookie;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;

@Mapping(value="/grit/ui/resource/entity")
@Controller
public class ResourceEntityController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;

    @Mapping
    public ModelAndView home(long space_id, Long group_id) throws SQLException {
        List spaceList = this.resourceAdminService.getSpaceList();
        spaceList.sort(ResourceComparator.instance);
        space_id = ResourceSpaceCookie.build((long)space_id, (List)spaceList);
        ResourceSpaceCookie.set((long)space_id);
        List groupList = this.resourceAdminService.getResourceGroupListBySpace(space_id);
        groupList = ResourceTreeUtils.build((List)groupList, (long)space_id);
        if (group_id == null && groupList.size() > 0) {
            group_id = ((ResourceGroup)groupList.get((int)0)).resource_id;
        }
        this.viewModel.put((Object)"space_id", (Object)space_id);
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"spaceList", (Object)spaceList);
        this.viewModel.put((Object)"groupList", (Object)groupList);
        return this.view("grit/ui/resource_entity");
    }

    @Mapping(value="inner")
    public ModelAndView inner(long group_id) throws SQLException {
        List list = this.resourceAdminService.getSubResourceListByPid(group_id);
        List list2 = list.stream().filter(r -> r.resource_type == 0).sorted((Comparator<Resource>)ResourceComparator.instance).collect(Collectors.toList());
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"list", list2);
        return this.view("grit/ui/resource_entity_inner");
    }
}

