/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.io.InputStream;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.client.utils.ResourceTreeUtils;
import org.noear.grit.model.data.ResourceDo;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.server.dso.ResourceSpaceCookie;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.grit.server.utils.JsondEntity;
import org.noear.grit.server.utils.JsondUtils;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.handle.UploadedFile;

@Mapping(value="/grit/ui/resource/entity")
@Controller
public class ResourceEntityController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;

    @Mapping
    public ModelAndView home(long space_id, Long group_id) throws SQLException {
        List spaceList = this.resourceAdminService.getSpaceList();
        spaceList.sort(ResourceComparator.instance);
        space_id = ResourceSpaceCookie.build((long)space_id, (List)spaceList);
        ResourceSpaceCookie.set((long)space_id);
        List groupList = this.resourceAdminService.getResourceGroupListBySpace(space_id);
        groupList = ResourceTreeUtils.build((List)groupList, (long)space_id);
        if (group_id == null && groupList.size() > 0) {
            group_id = ((ResourceGroup)groupList.get((int)0)).resource_id;
        }
        this.viewModel.put((Object)"space_id", (Object)space_id);
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"spaceList", (Object)spaceList);
        this.viewModel.put((Object)"groupList", (Object)groupList);
        return this.view("grit/ui/resource_entity");
    }

    @Mapping(value="inner")
    public ModelAndView inner(long group_id, int state) throws SQLException {
        boolean disabled = state == 1;
        List list = this.resourceAdminService.getSubResourceListByPid(group_id);
        list = list.stream().filter(r -> r.resource_type == 0 && r.is_disabled == disabled).sorted((Comparator<Resource>)ResourceComparator.instance).collect(Collectors.toList());
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"state", (Object)state);
        this.viewModel.put((Object)"list", list);
        return this.view("grit/ui/resource_entity_inner");
    }

    public void exportDo(Context ctx, long group_id, String ids) throws Exception {
        if (group_id == 0L) {
            return;
        }
        List list = this.resourceAdminService.getSubResourceListByPidAndIds(group_id, ids);
        String jsonD = JsondUtils.encode((String)"grit_resource", (Object)list);
        String filename = "grit_resource_" + group_id + "_" + LocalDate.now() + ".jsond";
        ctx.headerSet("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ctx.output(jsonD);
    }

    public Result importDo(Context ctx, long group_id, UploadedFile file) throws Exception {
        if (group_id == 0L) {
            return Result.failure();
        }
        try {
            String jsonD = Utils.transferToString((InputStream)file.content, (String)"UTF-8");
            JsondEntity entity = JsondUtils.decode((String)jsonD);
            if (entity == null || !"grit_resource".equals(entity.table)) {
                return Result.failure((String)"\u6570\u636e\u4e0d\u5bf9\uff01");
            }
            List list = entity.data.toObjectList(ResourceDo.class);
            Resource group = this.resourceAdminService.getResourceById(group_id);
            for (ResourceDo m : list) {
                m.resource_sid = group.resource_sid;
                m.resource_pid = group_id;
                this.resourceAdminService.synResourceByGuid(m);
            }
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }

    @Mapping(value="ajax/batch")
    public Result batchDo(Context ctx, long group_id, int act, String ids) throws Exception {
        try {
            if (act == 9) {
                this.resourceAdminService.delResourceByIds(ids);
            } else {
                this.resourceAdminService.desResourceByIds(ids, act == 1);
            }
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }
}

