/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.io.InputStream;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.client.utils.ResourceTreeUtils;
import org.noear.grit.model.data.ResourceDo;
import org.noear.grit.server.dso.ResourceSpaceCookie;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.grit.server.utils.JsondEntity;
import org.noear.grit.server.utils.JsondUtils;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.handle.UploadedFile;

@Mapping(value="/grit/ui/resource/group")
@Controller
public class ResourceGroupController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;

    @Mapping
    public ModelAndView home(long space_id) throws SQLException {
        List list = this.resourceAdminService.getSpaceList();
        list.sort(ResourceComparator.instance);
        space_id = ResourceSpaceCookie.build((long)space_id, (List)list);
        this.viewModel.put((Object)"space_id", (Object)space_id);
        this.viewModel.put((Object)"list", (Object)list);
        return this.view("grit/ui/resource_group");
    }

    @Mapping(value="inner")
    public ModelAndView inner(long space_id, int state) throws SQLException {
        boolean disabled = state == 1;
        List list = this.resourceAdminService.getResourceGroupListBySpace(space_id);
        list = list.stream().filter(r -> r.is_disabled == disabled).collect(Collectors.toList());
        list = ResourceTreeUtils.build(list, (long)space_id);
        ResourceSpaceCookie.set((long)space_id);
        this.viewModel.put((Object)"space_id", (Object)space_id);
        this.viewModel.put((Object)"state", (Object)state);
        this.viewModel.put((Object)"list", (Object)list);
        return this.view("grit/ui/resource_group_inner");
    }

    public void exportDo(Context ctx, long space_id, String ids) throws Exception {
        if (space_id == 0L) {
            return;
        }
        List list = this.resourceAdminService.getResourceGroupListBySpaceAndIds(space_id, ids);
        String jsonD = JsondUtils.encode((String)"grit_resource_group", (Object)list);
        String filename = "grit_resource_group_" + space_id + "_" + LocalDate.now() + ".jsond";
        ctx.headerSet("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ctx.output(jsonD);
    }

    public Result importDo(Context ctx, long space_id, UploadedFile file) throws Exception {
        if (space_id == 0L) {
            return Result.failure();
        }
        try {
            String jsonD = Utils.transferToString((InputStream)file.content, (String)"UTF-8");
            JsondEntity entity = JsondUtils.decode((String)jsonD);
            if (entity == null || !"grit_resource_group".equals(entity.table)) {
                return Result.failure((String)"\u6570\u636e\u4e0d\u5bf9\uff01");
            }
            List list = entity.data.toObjectList(ResourceDo.class);
            for (ResourceDo m : list) {
                m.resource_sid = space_id;
                m.resource_pid = space_id;
                this.resourceAdminService.synResourceByGuid(m);
            }
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }

    @Mapping(value="ajax/batch")
    public Result batchDo(Context ctx, long space_id, int act, String ids) throws Exception {
        try {
            if (act == 9) {
                this.resourceAdminService.delResourceByIds(ids);
            } else {
                this.resourceAdminService.desResourceByIds(ids, act == 1);
            }
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }
}

