/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.io.InputStream;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.List;
import org.noear.grit.client.comparator.ResourceComparator;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.grit.service.ResourceSchemaService;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.handle.UploadedFile;

@Mapping(value="/grit/ui/resource/space")
@Controller
public class ResourceSpaceController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;
    @Inject
    ResourceSchemaService resourceSchemaService;
    final String jsondTable = "grit_space";

    @Mapping
    public ModelAndView home() throws SQLException {
        List list = this.resourceAdminService.getSpaceList();
        list.sort(ResourceComparator.instance);
        this.viewModel.put((Object)"list", (Object)list);
        return this.view("grit/ui/resource_space");
    }

    @Mapping(value="ajax/import")
    public Result importDo(UploadedFile file) throws Exception {
        if (file == null) {
            return Result.failure();
        }
        try {
            String data = Utils.transferToString((InputStream)file.content, (String)"UTF-8");
            this.resourceSchemaService.importSchema(data);
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }

    @Mapping(value="ajax/export")
    public void exportDo(Context ctx, long space_id, String fmt) throws Exception {
        if (space_id == 0L) {
            return;
        }
        String data = this.resourceSchemaService.exportSchema(space_id, fmt);
        Resource space = this.resourceAdminService.getResourceById(space_id);
        String filename = null;
        filename = "json".equals(fmt) ? "grit_space_" + space.resource_code + "_" + LocalDate.now() + ".json" : "grit_space_" + space.resource_code + "_" + LocalDate.now() + ".jsond";
        ctx.headerSet("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ctx.output(data);
    }
}

