/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.sql.SQLException;
import java.util.HashSet;
import org.noear.grit.model.data.SubjectDo;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.model.type.SubjectType;
import org.noear.grit.server.dso.service.SubjectAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.annotation.NotEmpty;

@Mapping(value="/grit/ui/subject")
@Controller
public class SubjectController
extends BaseController {
    @Inject
    SubjectAdminService subjectAdminService;

    @Mapping(value="edit")
    public ModelAndView edit(long subject_id, long group_id, int type) throws SQLException {
        Subject m1 = this.subjectAdminService.getSubjectById(subject_id);
        if (m1.subject_id == null) {
            m1.subject_type = type;
            m1.is_disabled = false;
            m1.is_visibled = true;
            m1.subject_pid = group_id;
        }
        this.viewModel.put((Object)"group_id", (Object)group_id);
        this.viewModel.put((Object)"m1", (Object)m1);
        return this.view("grit/ui/subject_edit");
    }

    @Mapping(value="edit/ajax/save")
    public Result edit_ajax_save(long subject_id, long group_id, SubjectDo subject) throws SQLException {
        if (subject.is_disabled == null) {
            subject.is_disabled = false;
        }
        if (subject.is_visibled == null) {
            subject.is_visibled = false;
        }
        if (Utils.isEmpty((String)subject.display_name)) {
            return Result.failure((String)"The display name cannot be empty");
        }
        if (Utils.isNotEmpty((String)subject.display_name)) {
            subject.display_name = subject.display_name.trim();
        }
        if (Utils.isNotEmpty((String)subject.subject_code)) {
            subject.subject_code = subject.subject_code.trim();
        }
        if (Utils.isNotEmpty((String)subject.login_name)) {
            subject.login_name = subject.login_name.trim();
        }
        if (Utils.isNotEmpty((String)subject.login_password)) {
            subject.login_password = subject.login_password.trim();
        }
        if (subject_id > 0L) {
            this.subjectAdminService.updSubjectById(subject_id, subject);
        } else if (subject.subject_type == SubjectType.entity.code) {
            this.subjectAdminService.addSubjectEntity(subject, group_id);
        } else {
            this.subjectAdminService.addSubject(subject);
        }
        return Result.succeed();
    }

    @NotEmpty(value={"subject_ids"})
    @Mapping(value="edit/ajax/paste")
    public Result edit_ajax_paste(long group_id, String subject_ids) throws SQLException {
        String[] idStrAry;
        if (group_id == 0L) {
            return Result.failure();
        }
        for (String idStr : idStrAry = subject_ids.split(",")) {
            long subjectId;
            if (!Utils.isNotEmpty((String)idStr) || this.subjectAdminService.hasSubjectLink(subjectId = Long.parseLong(idStr), group_id)) continue;
            this.subjectAdminService.addSubjectLink(subjectId, group_id);
        }
        return Result.succeed();
    }

    @NotEmpty(value={"subject_ids"})
    @Mapping(value="edit/ajax/remove")
    public Result edit_ajax_remove(long group_id, String subject_ids) throws SQLException {
        String[] idStrAry;
        if (group_id == 0L) {
            return Result.failure();
        }
        HashSet<Long> subjectIds = new HashSet<Long>();
        for (String idStr : idStrAry = subject_ids.split(",")) {
            if (!Utils.isNotEmpty((String)idStr)) continue;
            long subjectId = Long.parseLong(idStr);
            subjectIds.add(subjectId);
        }
        if (subjectIds.size() > 0) {
            this.subjectAdminService.delSubjectLinkBySubjects(subjectIds, group_id);
        }
        return Result.succeed();
    }

    @Mapping(value="edit/ajax/del")
    public Result edit_ajax_del(long subject_id) throws SQLException {
        this.subjectAdminService.delSubjectById(subject_id);
        return Result.succeed();
    }
}

