/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.ui.controller;

import java.sql.SQLException;
import org.noear.grit.model.data.ResourceDo;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.type.ResourceType;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.ui.controller.BaseController;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;

@Mapping(value="/grit/ui/resource")
@Controller
public class ResourceController
extends BaseController {
    @Inject
    ResourceAdminService resourceAdminService;

    @Mapping(value="edit")
    public ModelAndView edit(long resource_id, long group_id, int type) throws SQLException {
        Resource m1 = this.resourceAdminService.getResourceById(resource_id);
        if (Resource.isEmpty((Resource)m1)) {
            m1.resource_type = type;
            m1.is_fullview = false;
            m1.is_disabled = false;
            m1.is_visibled = true;
            if (group_id > 0L) {
                Resource m2 = this.resourceAdminService.getResourceById(group_id);
                m1.resource_pid = group_id;
                m1.resource_sid = m2.resource_sid;
                if (m2.resource_type == ResourceType.space.code) {
                    m1.resource_sid = m2.resource_id;
                }
            }
        }
        this.viewModel.put("m1", (Object)m1);
        return this.view("grit/ui/resource_edit");
    }

    @Mapping(value="edit/ajax/save")
    public Result edit_ajax_save(long resource_id, ResourceDo resource) throws SQLException {
        if (resource.is_disabled == null) {
            resource.is_disabled = false;
        }
        if (resource.is_visibled == null) {
            resource.is_visibled = false;
        }
        if (resource.is_fullview == null) {
            resource.is_fullview = false;
        }
        if (resource.order_index == null) {
            resource.order_index = 0;
        }
        if (Utils.isEmpty((String)resource.display_name)) {
            return Result.failure((String)"The display name cannot be empty");
        }
        if (Utils.isNotEmpty((String)resource.display_name)) {
            resource.display_name = resource.display_name.trim();
        }
        if (Utils.isNotEmpty((String)resource.resource_code)) {
            resource.resource_code = resource.resource_code.trim();
        }
        if (Utils.isNotEmpty((String)resource.link_uri)) {
            resource.link_uri = resource.link_uri.trim();
        }
        if (Utils.isNotEmpty((String)resource.icon_uri)) {
            resource.icon_uri = resource.icon_uri.trim();
        }
        try {
            if (resource_id > 0L) {
                this.resourceAdminService.updResourceById(resource_id, resource);
            } else {
                this.resourceAdminService.addResource(resource);
            }
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }

    @Mapping(value="edit/ajax/del")
    public Result edit_ajax_del(long resource_id) throws SQLException {
        try {
            if (this.resourceAdminService.hasSubResourceByPid(resource_id)) {
                return Result.failure((String)"\u5b58\u5728\u4e0b\u7ea7\u8d44\u6e90,\u4e0d\u53ef\u5220\u9664");
            }
            this.resourceAdminService.delResourceById(resource_id);
            return Result.succeed();
        }
        catch (Throwable e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }
}

