/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.grit.client.GritClient;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.service.ResourceLinkService;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.cache.ICacheService;

@Before(value={BeforeHandler.class})
@Mapping(value="/grit/api/v1/ResourceLinkService")
@Remoting
public class ResourceLinkServiceImpl
implements ResourceLinkService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheService cache;

    public boolean hasResourceLink(long resourceId, long subjectId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked").whereEq("resource_id", (Object)resourceId)).andEq("subject_id", (Object)subjectId)).caching(this.cache)).selectExists();
    }

    public boolean hasResourceLinkBySubjects(long resourceId, Collection<Long> subjectIds) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked").whereEq("resource_id", (Object)resourceId)).andIn("subject_id", subjectIds)).caching(this.cache)).selectExists();
    }

    public List<Subject> getSubjectListByResource(long resourceId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_subject s")).on("l.subject_id=s.subject_id")).andEq("l.resource_id", (Object)resourceId)).caching(this.cache)).selectList("s.*", Subject.class);
    }

    public List<ResourceEntity> getResourceEntityListBySubject(long subjectId, Boolean isVisibled) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andEq("l.subject_id", (Object)subjectId)).whereIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).caching(this.cache)).selectList("r.*", ResourceEntity.class);
    }

    public List<ResourceEntity> getResourceEntityListBySubjectAndGroup(long subjectId, long resourceGroupId, Boolean isVisibled) throws SQLException {
        if (resourceGroupId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceGroupId=" + resourceGroupId);
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andEq("l.subject_id", (Object)subjectId)).andEq("r.resource_pid", (Object)resourceGroupId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).caching(this.cache)).selectList("r.*", ResourceEntity.class);
    }

    public List<ResourceEntity> getResourceEntityListBySubjectAndSpace(long subjectId, long resourceSpaceId, Boolean isVisibled) throws SQLException {
        if (resourceSpaceId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceSpaceId=" + resourceSpaceId);
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andEq("l.subject_id", (Object)subjectId)).andEq("r.resource_sid", (Object)resourceSpaceId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).caching(this.cache)).selectList("r.*", ResourceEntity.class);
    }

    public List<ResourceEntity> getResourceEntityListBySubjectsAndGroup(Collection<Long> subjectIds, long resourceGroupId, Boolean isVisibled) throws SQLException {
        if (resourceGroupId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceGroupId=" + resourceGroupId);
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andEq("r.resource_pid", (Object)resourceGroupId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).groupBy("r.resource_id")).caching(this.cache)).selectList("r.*", ResourceEntity.class);
    }

    public List<ResourceEntity> getResourceEntityListBySubjectsAndSpace(Collection<Long> subjectIds, long resourceSpaceId, Boolean isVisibled) throws SQLException {
        if (resourceSpaceId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceSpaceId=" + resourceSpaceId);
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andEq("r.resource_sid", (Object)resourceSpaceId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).caching(this.cache)).selectList("r.*", ResourceEntity.class);
    }

    public List<ResourceGroup> getResourceGroupListBySubjects(Collection<Long> subjectIds, long resourceSpaceId, Boolean isVisibled) throws SQLException {
        if (resourceSpaceId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceSpaceId=" + resourceSpaceId);
        }
        Set groupIds = GritClient.global().resource().getSubResourceListByPid(resourceSpaceId).stream().map(r -> r.resource_id).collect(Collectors.toSet());
        List groupIds2 = ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andIn("r.resource_pid", groupIds)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).groupBy("r.resource_pid")).caching(this.cache)).selectArray("r.resource_pid");
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereIn("resource_id", (Iterable)groupIds2)).andEq("is_visibled", (Object)1)).andEq("is_disabled", (Object)0)).caching(this.cache)).selectList("*", ResourceGroup.class);
    }

    public List<ResourceSpace> getResourceSpaceListBySubjects(Collection<Long> subjectIds, Boolean isVisibled) throws SQLException {
        List spaceIds = ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).groupBy("r.resource_sid")).caching(this.cache)).selectArray("r.resource_sid");
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereIn("resource_id", (Iterable)spaceIds)).andIf(isVisibled != null, "is_visibled=?", new Object[]{isVisibled})).andEq("is_disabled", (Object)0)).caching(this.cache)).selectList("*", ResourceSpace.class);
    }

    public ResourceEntity getResourceEntityFristBySubjectsAndSpace(Collection<Long> subjectIds, long resourceSpaceId, Boolean isVisibled) throws SQLException {
        if (resourceSpaceId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceSpaceId=" + resourceSpaceId);
        }
        return (ResourceEntity)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andEq("r.resource_sid", (Object)resourceSpaceId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).limit(1)).caching(this.cache)).selectItem("r.*", ResourceEntity.class);
    }

    public ResourceEntity getResourceEntityFristBySubjectsAndGroup(Collection<Long> subjectIds, long resourceGroupId, Boolean isVisibled) throws SQLException {
        if (resourceGroupId == 0L) {
            throw new IllegalArgumentException("Invalid parameter: resourceGroupId=" + resourceGroupId);
        }
        return (ResourceEntity)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource_linked l").innerJoin("grit_resource r")).on("l.resource_id=r.resource_id")).andIn("l.subject_id", subjectIds)).andEq("r.resource_pid", (Object)resourceGroupId)).andIf(isVisibled != null, "r.is_visibled=?", new Object[]{isVisibled})).andEq("r.is_disabled", (Object)0)).orderByAsc("r.order_index")).andByAsc("r.resource_id")).limit(1)).caching(this.cache)).selectItem("r.*", ResourceEntity.class);
    }
}

