/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.util.List;
import org.noear.grit.model.data.ResourceDo;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.server.dso.AfterHandler;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.server.dso.service.ResourceAdminService;
import org.noear.grit.server.utils.JsondEntity;
import org.noear.grit.server.utils.JsondUtils;
import org.noear.grit.service.ResourceSchemaService;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.data.annotation.Cache;

@Before(value={BeforeHandler.class})
@After(value={AfterHandler.class})
@Mapping(value="/grit/api/v1/ResourceSchemaService")
@Remoting
public class ResourceSchemaServiceImpl
implements ResourceSchemaService {
    @Inject
    ResourceAdminService adminService;
    final String jsondTable = "grit_space";
    final String tag_space = "space";
    final String tag_meta = "meta";
    final String tag_groups = "groups";
    final String tag_engitys = "engitys";

    public boolean importSchema(String jsond) throws Exception {
        if (Utils.isEmpty((String)jsond)) {
            return false;
        }
        JsondEntity jsondEntity = JsondUtils.decode(jsond);
        if (!"grit_space".equals(jsondEntity.table)) {
            throw new IllegalArgumentException("Invalid space schema json");
        }
        ONode oNode = jsondEntity.data;
        ONode oSpace = oNode.getOrNull("space");
        if (oSpace == null) {
            throw new IllegalArgumentException("Invalid space schema json");
        }
        ResourceDo spaceD = (ResourceDo)oSpace.get("meta").toObject(ResourceDo.class);
        spaceD.resource_sid = 0L;
        spaceD.resource_pid = 0L;
        if (Utils.isEmpty((String)spaceD.guid) && Utils.isNotEmpty((String)spaceD.resource_code)) {
            Resource spaceTmp = this.adminService.getResourceByCode(spaceD.resource_code);
            if (spaceTmp.guid != null) {
                spaceD.guid = spaceTmp.guid;
            }
        }
        if (!this.adminService.synResourceByGuid(spaceD)) {
            throw new IllegalArgumentException("Invalid space schema json");
        }
        ONode oGroups = oSpace.getOrNull("groups");
        if (oGroups == null) {
            throw new IllegalArgumentException("Invalid space schema json");
        }
        for (ONode oG1 : oGroups.ary()) {
            ResourceDo g1 = (ResourceDo)oG1.get("meta").toObject(ResourceDo.class);
            g1.resource_pid = spaceD.resource_id;
            g1.resource_sid = spaceD.resource_id;
            if (!this.adminService.synResourceByGuid(g1)) {
                throw new IllegalArgumentException("Invalid space schema json");
            }
            List engitys = oG1.get("engitys").toObjectList(ResourceDo.class);
            for (ResourceDo e1 : engitys) {
                e1.resource_sid = g1.resource_sid;
                e1.resource_pid = g1.resource_id;
                if (this.adminService.synResourceByGuid(e1)) continue;
                throw new IllegalArgumentException("Invalid space schema json");
            }
        }
        return false;
    }

    @Cache(seconds=10)
    public String exportSchema(long resourceSpaceId) throws Exception {
        if (resourceSpaceId == 0L) {
            return "";
        }
        ONode oNode = new ONode();
        Resource space = this.adminService.getResourceById(resourceSpaceId);
        List<ResourceGroup> groups = this.adminService.getResourceGroupListBySpace(resourceSpaceId);
        space.resource_id = null;
        space.resource_pid = null;
        space.resource_sid = null;
        ONode oSpace = oNode.getOrNew("space");
        oSpace.getOrNew("meta").fill((Object)space);
        ONode oGroups = oSpace.getOrNew("groups").asArray();
        for (ResourceGroup g1 : groups) {
            List<Resource> engitys = this.adminService.getSubResourceListByPid(g1.resource_id);
            g1.resource_id = null;
            g1.resource_pid = null;
            g1.resource_sid = null;
            ONode oG1 = oGroups.addNew();
            oG1.getOrNew("meta").fill((Object)g1);
            ONode oEngitys = oG1.getOrNew("engitys");
            for (Resource e1 : engitys) {
                e1.resource_id = null;
                e1.resource_pid = null;
                e1.resource_sid = null;
                oEngitys.addNew().fill((Object)e1);
            }
        }
        return JsondUtils.encode("grit_space", oNode);
    }
}

