/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.sql.SQLException;
import java.util.List;
import org.noear.grit.model.domain.SubjectEntity;
import org.noear.grit.model.domain.SubjectGroup;
import org.noear.grit.server.dso.AfterHandler;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.service.SubjectLinkService;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.cache.ICacheService;

@Before(value={BeforeHandler.class})
@After(value={AfterHandler.class})
@Mapping(value="/grit/api/v1/SubjectLinkService")
@Remoting
public class SubjectLinkServiceImpl
implements SubjectLinkService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheService cache;

    public boolean hasSubjectLink(long subjectId, long subjectGroupId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereEq("subject_id", (Object)subjectId)).andEq("group_subject_id", (Object)subjectGroupId)).caching(this.cache)).selectExists();
    }

    public List<SubjectEntity> getSubjectEntityListByGroup(long subjectGroupId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereEq("group_subject_id", (Object)subjectGroupId)).caching(this.cache)).selectList("*", SubjectEntity.class);
    }

    public List<SubjectGroup> getSubjectGroupListByEntity(long subjectId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked l").innerJoin("grit_subject s")).onEq("l.subject_id", "s.group_subject_id")).andEq("l.subject_id", (Object)subjectId)).caching(this.cache)).selectList("s.*", SubjectGroup.class);
    }

    public List<Long> getSubjectGroupIdListByEntity(long subjectId) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject_linked").whereEq("subject_id", (Object)subjectId)).caching(this.cache)).selectArray("group_subject_id");
    }
}

