/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.dso;

import java.sql.SQLException;
import org.noear.grit.client.GritClient;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.service.AuthService;
import org.noear.grit.service.ResourceLinkService;
import org.noear.grit.service.ResourceService;
import org.noear.grit.service.SubjectLinkService;
import org.noear.grit.service.SubjectService;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;

@Component
public class GritClientLocalImpl
implements GritClient {
    @Inject
    private ResourceService resourceService;
    @Inject
    private ResourceLinkService resourceLinkService;
    @Inject
    private SubjectService subjectService;
    @Inject
    private SubjectLinkService subjectLinkService;
    @Inject
    private AuthService authService;
    private long currentSpaceId;
    private String currentSpaceCode;

    public void setCurrentSpaceByCode(String resourceSpaceCode) {
        if (resourceSpaceCode == null || resourceSpaceCode.equals(this.currentSpaceCode)) {
            return;
        }
        try {
            this.currentSpaceCode = resourceSpaceCode;
            ResourceSpace space = this.resource().getSpaceByCode(resourceSpaceCode);
            if (space.resource_id != null) {
                this.currentSpaceId = space.resource_id;
            } else {
                System.out.println("[Grit] Invalid resource space code: " + resourceSpaceCode);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCurrentSpaceCode() {
        return this.currentSpaceCode;
    }

    public long getCurrentSpaceId() {
        return this.currentSpaceId;
    }

    public ResourceService resource() {
        return this.resourceService;
    }

    public ResourceLinkService resourceLink() {
        return this.resourceLinkService;
    }

    public SubjectService subject() {
        return this.subjectService;
    }

    public SubjectLinkService subjectLink() {
        return this.subjectLinkService;
    }

    public AuthService auth() {
        return this.authService;
    }
}

