/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.grit.client.utils.TextUtils;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.model.type.ResourceType;
import org.noear.grit.server.dso.AfterHandler;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.service.ResourceService;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.cache.ICacheService;

@Before(value={BeforeHandler.class})
@After(value={AfterHandler.class})
@Mapping(value="/grit/api/v1/ResourceService")
@Remoting
public class ResourceServiceImpl
implements ResourceService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheService cache;

    public Resource getResourceById(long resourceId) throws SQLException {
        return (Resource)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_id", (Object)resourceId)).caching(this.cache)).selectItem("*", Resource.class);
    }

    public Resource getResourceByGuid(long resourceGuid) throws SQLException {
        return (Resource)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("guid", (Object)resourceGuid)).caching(this.cache)).selectItem("*", Resource.class);
    }

    public boolean hasResourceByGuid(long resourceGuid) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("guid", (Object)resourceGuid)).caching(this.cache)).selectExists();
    }

    public Resource getResourceByCodeAndSpace(long resourceSpaceId, String resourceCode) throws SQLException {
        if (TextUtils.isEmpty((String)resourceCode)) {
            return new Resource();
        }
        return (Resource)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_code", (Object)resourceCode)).andIf(resourceSpaceId > 0L, "resource_sid=?", new Object[]{resourceSpaceId})).limit(1)).caching(this.cache)).selectItem("*", Resource.class);
    }

    public Resource getResourceByUriAndSpace(long resourceSpaceId, String resourceUri) throws SQLException {
        if (TextUtils.isEmpty((String)resourceUri)) {
            return new Resource();
        }
        return (Resource)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("link_uri", (Object)resourceUri)).andIf(resourceSpaceId > 0L, "resource_sid=?", new Object[]{resourceSpaceId})).limit(1)).caching(this.cache)).selectItem("*", Resource.class);
    }

    public boolean hasResourceByCodeAndSpace(long resourceSpaceId, String resourceCode) throws SQLException {
        if (TextUtils.isEmpty((String)resourceCode)) {
            return false;
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_code", (Object)resourceCode)).andIf(resourceSpaceId > 0L, "resource_sid=?", new Object[]{resourceSpaceId})).limit(1)).caching(this.cache)).selectExists();
    }

    public boolean hasResourceByUriAndSpace(long resourceSpaceId, String resourceUri) throws SQLException {
        if (TextUtils.isEmpty((String)resourceUri)) {
            return false;
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("link_uri", (Object)resourceUri)).andIf(resourceSpaceId > 0L, "resource_sid=?", new Object[]{resourceSpaceId})).caching(this.cache)).selectExists();
    }

    public List<Resource> getSubResourceListByPid(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<Resource>();
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_pid", (Object)resourceId)).caching(this.cache)).selectList("*", Resource.class);
    }

    public List<ResourceEntity> getSubResourceEngityListByPid(long resourceId) throws SQLException {
        if (resourceId == 0L) {
            return new ArrayList<ResourceEntity>();
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_pid", (Object)resourceId)).andEq("resource_type", (Object)ResourceType.entity.code)).caching(this.cache)).selectList("*", ResourceEntity.class);
    }

    public ResourceSpace getSpaceByCode(String resourceSpaceCode) throws SQLException {
        if (TextUtils.isEmpty((String)resourceSpaceCode)) {
            return new ResourceSpace();
        }
        return (ResourceSpace)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_code", (Object)resourceSpaceCode)).limit(1)).caching(this.cache)).selectItem("*", ResourceSpace.class);
    }

    public boolean hasSpaceByCode(String resourceSpaceCode) throws SQLException {
        if (TextUtils.isEmpty((String)resourceSpaceCode)) {
            return false;
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_code", (Object)resourceSpaceCode)).caching(this.cache)).selectExists();
    }

    public List<ResourceSpace> getSpaceList() throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_resource").whereEq("resource_type", (Object)ResourceType.space.code)).andEq("is_visibled", (Object)1)).andEq("is_disabled", (Object)0)).caching(this.cache)).selectList("*", ResourceSpace.class);
    }
}

