/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.server.controller;

import java.sql.SQLException;
import org.noear.grit.client.GritUtil;
import org.noear.grit.client.utils.TextUtils;
import org.noear.grit.model.data.SubjectDo;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.server.dso.AfterHandler;
import org.noear.grit.server.dso.BeforeHandler;
import org.noear.grit.service.SubjectService;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Addition;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.wood.DbContext;
import org.noear.wood.DbTableQuery;
import org.noear.wood.cache.ICacheService;
import org.noear.wood.cache.ICacheServiceEx;

@Addition(value={BeforeHandler.class, AfterHandler.class})
@Mapping(value="/grit/api/v1/SubjectService")
@Remoting
public class SubjectServiceImpl
implements SubjectService {
    @Inject(value="grit.db")
    private DbContext db;
    @Inject(value="grit.cache")
    private ICacheServiceEx cache;

    public boolean hasSubjectByLoginName(String loginName) throws SQLException {
        if (TextUtils.isEmpty((String)loginName)) {
            return false;
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("login_name", (Object)loginName)).limit(1)).selectExists();
    }

    public boolean hasSubjectByCode(String subjectCode) throws SQLException {
        if (TextUtils.isEmpty((String)subjectCode)) {
            return false;
        }
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_code", (Object)subjectCode)).caching((ICacheService)this.cache)).selectExists();
    }

    public Subject getSubjectByLoginName(String loginName) throws SQLException {
        if (TextUtils.isEmpty((String)loginName)) {
            return new Subject();
        }
        return (Subject)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("login_name", (Object)loginName)).limit(1)).caching((ICacheService)this.cache)).selectItem("*", Subject.class);
    }

    public Subject getSubjectByLoginNameAndPassword(String loginName, String loginPassword) throws SQLException {
        if (TextUtils.isEmpty((String)loginName) || TextUtils.isEmpty((String)loginPassword)) {
            return new Subject();
        }
        String loginPasswordHash = GritUtil.buildPassword((String)loginName, (String)loginPassword);
        return (Subject)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").log(true)).whereEq("login_name", (Object)loginName)).andEq("login_password", (Object)loginPasswordHash)).andEq("is_disabled", (Object)0)).selectItem("*", Subject.class);
    }

    public Subject getSubjectById(long subjectId) throws SQLException {
        if (subjectId < 1L) {
            return new Subject();
        }
        return (Subject)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_id", (Object)subjectId)).caching((ICacheService)this.cache)).selectItem("*", Subject.class);
    }

    public Subject getSubjectByCode(String subjectCode) throws SQLException {
        if (TextUtils.isEmpty((String)subjectCode)) {
            return new Subject();
        }
        return (Subject)((DbTableQuery)((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").whereEq("subject_code", (Object)subjectCode)).limit(1)).caching((ICacheService)this.cache)).selectItem("*", Subject.class);
    }

    public int modSubjectPassword(String loginName, String loginPassword, String newLoginPassword) throws SQLException {
        if (TextUtils.isEmpty((String)loginName) || TextUtils.isEmpty((String)loginPassword) || TextUtils.isEmpty((String)newLoginPassword)) {
            return 0;
        }
        Subject subject = this.getSubjectByLoginNameAndPassword(loginName, loginPassword);
        if (subject.subject_id > 0L) {
            String loginNewPasswordHash = GritUtil.buildPassword((String)loginName, (String)newLoginPassword);
            return ((DbTableQuery)this.db.table("grit_subject").set("login_password", (Object)loginNewPasswordHash).whereEq("subject_id", (Object)subject.subject_id)).update() > 0 ? 2 : 0;
        }
        return 1;
    }

    public long regSubject(String loginName, String loginPassword, String displayName) throws SQLException {
        SubjectDo subject = new SubjectDo();
        subject.subject_pid = -1L;
        subject.login_name = loginName;
        subject.login_password = loginPassword;
        subject.login_password = Utils.isNotEmpty((String)subject.login_password) ? GritUtil.buildPassword((String)subject.login_name, (String)subject.login_password) : "";
        subject.gmt_modified = subject.gmt_create = Long.valueOf(System.currentTimeMillis());
        return ((DbTableQuery)((DbTableQuery)this.db.table("grit_subject").setEntity((Object)subject).usingNull(false)).usingExpr(false)).insert();
    }

    public int setSubjectPassword(String loginName, String newLoginPassword) throws SQLException {
        if (TextUtils.isEmpty((String)loginName) || TextUtils.isEmpty((String)newLoginPassword)) {
            return 0;
        }
        Subject subject = this.getSubjectByLoginName(loginName);
        if (subject.subject_id > 0L) {
            String loginNewPasswordHash = GritUtil.buildPassword((String)loginName, (String)newLoginPassword);
            return ((DbTableQuery)this.db.table("grit_subject").set("login_password", (Object)loginNewPasswordHash).whereEq("subject_id", (Object)subject.subject_id)).update() > 0 ? 2 : 0;
        }
        return 1;
    }

    public int setSubjectDisabled(long subjectId, boolean disabled) throws SQLException {
        if (subjectId < 1L) {
            return 0;
        }
        return ((DbTableQuery)this.db.table("grit_subject").set("is_disabled", (Object)(disabled ? 1 : 0)).whereEq("subject_id", (Object)subjectId)).update();
    }

    public int setSubjectVisibled(long subjectId, boolean visibled) throws SQLException {
        if (subjectId < 1L) {
            return 0;
        }
        return ((DbTableQuery)this.db.table("grit_subject").set("is_visibled", (Object)(visibled ? 1 : 0)).whereEq("subject_id", (Object)subjectId)).update();
    }

    public int setSubjectAttrs(long subjectId, String attrs) throws SQLException {
        if (subjectId < 1L) {
            return 0;
        }
        if (attrs == null) {
            attrs = "";
        }
        return ((DbTableQuery)this.db.table("grit_subject").set("attrs", (Object)attrs).whereEq("subject_id", (Object)subjectId)).update();
    }
}

